/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.crypto.key;

import de.rub.nds.protocol.constants.AsymmetricAlgorithmType;
import de.rub.nds.protocol.constants.NamedEllipticCurveParameters;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.crypto.key.PublicKeyContainer;
import java.math.BigInteger;

public class EcdhPublicKey
implements PublicKeyContainer {
    private Point publicPoint;
    private NamedEllipticCurveParameters parameters;

    private EcdhPublicKey() {
        this.publicPoint = null;
        this.parameters = null;
    }

    public EcdhPublicKey(Point publicPoint, NamedEllipticCurveParameters parameters) {
        this.publicPoint = publicPoint;
        this.parameters = parameters;
    }

    public EcdhPublicKey(BigInteger publicPointX, BigInteger publicPointY, NamedEllipticCurveParameters parameters) {
        this.publicPoint = parameters.getGroup().getPoint(publicPointX, publicPointY);
        this.parameters = parameters;
    }

    public Point getPublicPoint() {
        return this.publicPoint;
    }

    public void setPublicPoint(Point publicPoint) {
        this.publicPoint = publicPoint;
    }

    public NamedEllipticCurveParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(NamedEllipticCurveParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public int length() {
        return this.parameters.getElementSizeBits();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.publicPoint == null ? 0 : this.publicPoint.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EcdhPublicKey other = (EcdhPublicKey)obj;
        if (this.publicPoint == null ? other.publicPoint != null : !this.publicPoint.equals(other.publicPoint)) {
            return false;
        }
        return this.parameters == other.parameters;
    }

    @Override
    public AsymmetricAlgorithmType getAlgorithmType() {
        return AsymmetricAlgorithmType.ECDH;
    }
}

