/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.crypto.key;

import de.rub.nds.protocol.constants.DsaParameters;
import de.rub.nds.protocol.crypto.dsa.ExplicitDsaParameters;
import de.rub.nds.protocol.crypto.key.PrivateKeyContainer;
import java.math.BigInteger;

public class DsaPrivateKey
implements PrivateKeyContainer {
    private BigInteger X;
    private BigInteger K;
    private DsaParameters dsaParameters;

    private DsaPrivateKey() {
        this.X = null;
        this.K = null;
        this.dsaParameters = null;
    }

    public DsaPrivateKey(BigInteger Q, BigInteger X, BigInteger K, BigInteger generator, BigInteger modulus) {
        this.dsaParameters = new ExplicitDsaParameters(modulus, Q, generator);
        this.X = X;
        this.K = K;
    }

    public DsaPrivateKey(BigInteger X, BigInteger K, DsaParameters dsaParameters) {
        this.dsaParameters = dsaParameters;
        this.X = X;
        this.K = K;
    }

    public DsaParameters getDsaParameters() {
        return this.dsaParameters;
    }

    public void setDsaParameters(DsaParameters dsaParameters) {
        this.dsaParameters = dsaParameters;
    }

    public BigInteger getModulus() {
        return this.dsaParameters.getP();
    }

    public BigInteger getGenerator() {
        return this.dsaParameters.getG();
    }

    public BigInteger getQ() {
        return this.dsaParameters.getQ();
    }

    public BigInteger getX() {
        return this.X;
    }

    public void setX(BigInteger x) {
        this.X = x;
    }

    public BigInteger getK() {
        return this.K;
    }

    public void setK(BigInteger k) {
        this.K = k;
    }
}

