/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.preparator;

import de.rub.nds.asn1.constants.TimeAccurracy;
import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.asn1.model.Asn1GeneralizedTime;
import de.rub.nds.asn1.model.Asn1UtcTime;
import de.rub.nds.asn1.preparator.Asn1PreparatorHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.constants.TimeContextHint;
import de.rub.nds.x509attacker.constants.ValidityEncoding;
import de.rub.nds.x509attacker.x509.model.Time;
import de.rub.nds.x509attacker.x509.preparator.X509Preparator;
import org.joda.time.DateTime;

public class TimePreparator
implements X509Preparator {
    private final X509Chooser chooser;
    private final Time time;

    public TimePreparator(X509Chooser chooser, Time time) {
        this.chooser = chooser;
        this.time = time;
    }

    @Override
    public void prepare() {
        TimeAccurracy accurracy;
        DateTime dateTime;
        ValidityEncoding timeEncoding;
        if (this.time.getTimeContext() == TimeContextHint.NOT_AFTER) {
            timeEncoding = this.chooser.getConfig().getDefaultNotAfterEncoding();
            dateTime = this.chooser.getConfig().getNotAfter();
            accurracy = this.chooser.getConfig().getNotAfterAccurracy();
        } else if (this.time.getTimeContext() == TimeContextHint.NOT_BEFORE) {
            timeEncoding = this.chooser.getConfig().getDefaultNotBeforeEncoding();
            dateTime = this.chooser.getConfig().getNotBefore();
            accurracy = this.chooser.getConfig().getNotBeforeAccurracy();
        } else {
            throw new RuntimeException("Something went wrong. Unexpected TimeContextHint.");
        }
        Object timeField = timeEncoding.isGeneralizedTime() ? new Asn1GeneralizedTime("generalizedTime") : new Asn1UtcTime("utcTime");
        this.time.makeSelection((Asn1Encodable)timeField);
        switch (timeEncoding) {
            case GENERALIZED_TIME_DIFFERENTIAL: {
                Asn1PreparatorHelper.prepareFieldGeneralizedTimeUtcDifferential((Asn1GeneralizedTime)timeField, (DateTime)dateTime, (TimeAccurracy)accurracy, (int)this.chooser.getConfig().getTimezoneOffsetInMinutes());
                break;
            }
            case GENERALIZED_TIME_LOCAL: {
                Asn1PreparatorHelper.prepareFieldGeneralizedTime((Asn1GeneralizedTime)timeField, (DateTime)dateTime, (TimeAccurracy)accurracy);
                break;
            }
            case GENERALIZED_TIME_UTC: {
                Asn1PreparatorHelper.prepareFieldGeneralizedTimeUtc((Asn1GeneralizedTime)timeField, (DateTime)dateTime, (TimeAccurracy)accurracy);
                break;
            }
            case UTC: {
                Asn1PreparatorHelper.prepareFieldUtcTime((Asn1UtcTime)((Asn1UtcTime)timeField), (DateTime)dateTime, (TimeAccurracy)accurracy);
                break;
            }
            case UTC_DIFFERENTIAL: {
                Asn1PreparatorHelper.prepareFieldUtcTimeDifferential((Asn1UtcTime)((Asn1UtcTime)timeField), (DateTime)dateTime, (TimeAccurracy)accurracy, (int)this.chooser.getConfig().getTimezoneOffsetInMinutes());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unimplemented time encoding: " + String.valueOf((Object)timeEncoding));
            }
        }
    }
}

