/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.preparator;

import de.rub.nds.asn1.model.Asn1BitString;
import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.model.Asn1OctetString;
import de.rub.nds.asn1.preparator.Asn1PreparatorHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.x509.model.TbsCertificate;
import de.rub.nds.x509attacker.x509.preparator.X509ContainerPreparator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TbsCertificatePreparator
extends X509ContainerPreparator<TbsCertificate> {
    private static final Logger LOGGER = LogManager.getLogger();

    public TbsCertificatePreparator(X509Chooser chooser, TbsCertificate tbsCertificate) {
        super(chooser, tbsCertificate);
    }

    @Override
    public void prepareSubComponents() {
        this.prepareVersion();
        this.prepareSerialNumber();
        this.prepareSignature();
        this.prepareIssuer();
        this.prepareValidity();
        this.prepareSubject();
        this.prepareSubjectPublicKeyInfo();
        this.prepareIssuerUniqueId();
        this.prepareSubjectUniqueId();
        this.prepareExtensions();
    }

    private void prepareVersion() {
        ((TbsCertificate)this.field).getVersion().getPreparator(this.chooser).prepare();
    }

    private void prepareSerialNumber() {
        if (this.chooser.getConfig().isIncludeSerialNumber()) {
            Asn1Integer serialNumber = ((TbsCertificate)this.field).getSerialNumber();
            Asn1PreparatorHelper.prepareField((Asn1Integer)serialNumber, (BigInteger)this.chooser.getConfig().getSerialNumber());
        }
    }

    private void prepareSignature() {
        ((TbsCertificate)this.field).getSignature().getPreparator(this.chooser).prepare();
        ((TbsCertificate)this.field).getSignature().getHandler(this.chooser).adjustContextAfterPrepare();
    }

    private void prepareIssuer() {
        if (this.chooser.getConfig().isIncludeIssuer()) {
            ((TbsCertificate)this.field).getIssuer().getPreparator(this.chooser).prepare();
            ((TbsCertificate)this.field).getIssuer().getHandler(this.chooser).adjustContextAfterPrepare();
        }
    }

    private void prepareValidity() {
        if (this.chooser.getConfig().isIncludeValidity()) {
            ((TbsCertificate)this.field).getValidity().getPreparator(this.chooser).prepare();
            ((TbsCertificate)this.field).getValidity().getHandler(this.chooser).adjustContextAfterPrepare();
        }
    }

    private void prepareSubject() {
        if (this.chooser.getConfig().isIncludeSubject()) {
            ((TbsCertificate)this.field).getSubject().getPreparator(this.chooser).prepare();
            ((TbsCertificate)this.field).getSubject().getHandler(this.chooser).adjustContextAfterPrepare();
        }
    }

    private void prepareSubjectPublicKeyInfo() {
        if (this.chooser.getConfig().isIncludeSubjectPublicKeyInfo()) {
            ((TbsCertificate)this.field).getSubjectPublicKeyInfo().getPreparator(this.chooser).prepare();
            ((TbsCertificate)this.field).getSubjectPublicKeyInfo().getHandler(this.chooser).adjustContextAfterPrepare();
        }
    }

    private void prepareIssuerUniqueId() {
        if (this.chooser.getConfig().isIncludeIssuerUniqueId()) {
            Asn1PreparatorHelper.prepareField((Asn1BitString)((TbsCertificate)this.field).getIssuerUniqueId(), (byte[])this.chooser.getIssuerUniqueId(), (byte)0);
        }
    }

    private void prepareSubjectUniqueId() {
        if (this.chooser.getConfig().isIncludeSubjectUniqueId()) {
            Asn1PreparatorHelper.prepareField((Asn1BitString)((TbsCertificate)this.field).getSubjectUniqueId(), (byte[])this.chooser.getConfig().getSubjectUniqueId(), (byte)0);
        }
    }

    private void prepareExtensions() {
        if (this.chooser.getConfig().isIncludeExtensions()) {
            ((TbsCertificate)this.field).getExplicitExtensions().getPreparator(this.chooser).prepare();
            ((TbsCertificate)this.field).getExplicitExtensions().getHandler(this.chooser).adjustContextAfterPrepare();
        }
    }

    @Override
    public byte[] encodeChildrenContent() {
        ArrayList<Asn1Encodable> children = new ArrayList<Asn1Encodable>();
        children.add(((TbsCertificate)this.field).getVersion());
        children.add((Asn1Encodable)((TbsCertificate)this.field).getSerialNumber());
        children.add(((TbsCertificate)this.field).getSignature());
        if (this.chooser.getConfig().isIncludeIssuer()) {
            children.add(((TbsCertificate)this.field).getIssuer());
        }
        children.add(((TbsCertificate)this.field).getValidity());
        if (this.chooser.getConfig().isIncludeSubject()) {
            children.add(((TbsCertificate)this.field).getSubject());
        }
        children.add(((TbsCertificate)this.field).getSubjectPublicKeyInfo());
        children.add((Asn1Encodable)((TbsCertificate)this.field).getIssuerUniqueId());
        children.add((Asn1Encodable)((TbsCertificate)this.field).getSubjectUniqueId());
        children.add(((TbsCertificate)this.field).getExplicitExtensions());
        if (this.chooser.getConfig().isAppendUnexpectedCertificateField()) {
            Asn1OctetString octetString = new Asn1OctetString("unexpectedField");
            Asn1PreparatorHelper.prepareField((Asn1OctetString)octetString, (byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
            children.add((Asn1Encodable)octetString);
        }
        children.removeIf(Objects::isNull);
        return this.encodeChildren(children);
    }
}

