/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.preparator;

import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.oid.ObjectIdentifier;
import de.rub.nds.asn1.preparator.Asn1PreparatorHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.constants.X509PublicKeyType;
import de.rub.nds.x509attacker.x509.model.SubjectPublicKeyAlgorithmIdentifier;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.PublicParameters;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509DhParameters;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509DssParameters;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509EcNamedCurveParameters;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509NullParameters;
import de.rub.nds.x509attacker.x509.preparator.X509ContainerPreparator;

public class SubjectPublicKeyAlgorithmIdentifierPreparator
extends X509ContainerPreparator<SubjectPublicKeyAlgorithmIdentifier> {
    public SubjectPublicKeyAlgorithmIdentifierPreparator(X509Chooser chooser, SubjectPublicKeyAlgorithmIdentifier subjectPublicKeyAlgorithmIdentifier) {
        super(chooser, subjectPublicKeyAlgorithmIdentifier);
    }

    @Override
    public void prepareSubComponents() {
        Asn1PreparatorHelper.prepareField((Asn1ObjectIdentifier)((SubjectPublicKeyAlgorithmIdentifier)this.field).getAlgorithm(), (ObjectIdentifier)this.chooser.getConfig().getPublicKeyType().getOid());
        PublicParameters publicKeyParameters = ((SubjectPublicKeyAlgorithmIdentifier)this.field).getParameters();
        if (publicKeyParameters == null && this.chooser.getConfig().getPublicKeyType() != X509PublicKeyType.RSASSA_PSS) {
            publicKeyParameters = this.createPublicKeyParameters();
            ((SubjectPublicKeyAlgorithmIdentifier)this.field).setParameters(publicKeyParameters);
        }
        if (publicKeyParameters != null) {
            publicKeyParameters.getPreparator(this.chooser).prepare();
            publicKeyParameters.getHandler(this.chooser).adjustContextAfterPrepare();
            ((SubjectPublicKeyAlgorithmIdentifier)this.field).setParameters(publicKeyParameters);
        }
    }

    private PublicParameters createPublicKeyParameters() {
        X509PublicKeyType publicKeyType = this.chooser.getConfig().getPublicKeyType();
        switch (publicKeyType) {
            case DH: {
                return new X509DhParameters("dhParameters", this.chooser.getConfig());
            }
            case DSA: {
                return new X509DssParameters("dssParameters");
            }
            case ECDH_ECDSA: {
                return new X509EcNamedCurveParameters("ecNamedCurve");
            }
            case RSA: {
                return new X509NullParameters("nullParameters");
            }
        }
        throw new UnsupportedOperationException("Unnown PublicKeyType: " + String.valueOf((Object)publicKeyType));
    }

    @Override
    public byte[] encodeChildrenContent() {
        if (((SubjectPublicKeyAlgorithmIdentifier)this.field).getParameters() != null) {
            return this.encodeChildren(new Asn1Encodable[]{((SubjectPublicKeyAlgorithmIdentifier)this.field).getAlgorithm(), ((SubjectPublicKeyAlgorithmIdentifier)this.field).getParameters()});
        }
        return this.encodeChildren(new Asn1Encodable[]{((SubjectPublicKeyAlgorithmIdentifier)this.field).getAlgorithm()});
    }
}

