/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.parser.publickey.parameters;

import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.parser.ParserHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509DssParameters;
import de.rub.nds.x509attacker.x509.parser.X509ComponentContainerParser;
import java.io.BufferedInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class X509DssParametersParser
extends X509ComponentContainerParser<X509DssParameters> {
    private static final Logger LOGGER = LogManager.getLogger();

    public X509DssParametersParser(X509Chooser chooser, X509DssParameters x509DssParameters) {
        super(chooser, x509DssParameters);
    }

    @Override
    protected void parseSubcomponents(BufferedInputStream inputStream) {
        LOGGER.debug("Parsing DssParameters");
        this.parseP(inputStream);
        this.parseQ(inputStream);
        this.parseG(inputStream);
    }

    private void parseG(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1Integer((Asn1Integer)((X509DssParameters)this.encodable).getG(), (BufferedInputStream)inputStream);
        LOGGER.debug("Parsing G: {}", ((X509DssParameters)this.encodable).getG().getValue().getValue());
    }

    private void parseQ(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1Integer((Asn1Integer)((X509DssParameters)this.encodable).getQ(), (BufferedInputStream)inputStream);
        LOGGER.debug("Parsing Q: {}", ((X509DssParameters)this.encodable).getQ().getValue().getValue());
    }

    private void parseP(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1Integer((Asn1Integer)((X509DssParameters)this.encodable).getP(), (BufferedInputStream)inputStream);
        LOGGER.debug("Parsing P: {}", ((X509DssParameters)this.encodable).getP().getValue().getValue());
    }
}

