/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.parser.publickey.parameters;

import de.rub.nds.asn1.constants.TagClass;
import de.rub.nds.asn1.constants.UniversalTagNumber;
import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.parser.ParserHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509DhParameters;
import de.rub.nds.x509attacker.x509.parser.X509ComponentContainerParser;
import java.io.BufferedInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class X509DhParametersParser
extends X509ComponentContainerParser<X509DhParameters> {
    private static final Logger LOGGER = LogManager.getLogger();

    public X509DhParametersParser(X509Chooser chooser, X509DhParameters x509DhParameters) {
        super(chooser, x509DhParameters);
    }

    @Override
    protected void parseSubcomponents(BufferedInputStream inputStream) {
        LOGGER.debug("Parsing DhParameters");
        this.parseP(inputStream);
        this.parseG(inputStream);
        if (this.hasQParameter(inputStream)) {
            this.parseQ(inputStream);
        }
        if (this.hasJParameter(inputStream)) {
            this.parseJ(inputStream);
        }
        if (this.hasValidationParams(inputStream)) {
            this.parseValidationParams(inputStream);
        }
    }

    private boolean hasValidationParams(BufferedInputStream inputStream) {
        return ParserHelper.canParse((BufferedInputStream)inputStream, (TagClass)TagClass.UNIVERSAL, (int)UniversalTagNumber.SEQUENCE.getIntValue());
    }

    private boolean hasQParameter(BufferedInputStream inputStream) {
        return ParserHelper.canParse((BufferedInputStream)inputStream, (TagClass)TagClass.UNIVERSAL, (int)UniversalTagNumber.INTEGER.getIntValue());
    }

    private boolean hasJParameter(BufferedInputStream inputStream) {
        return ParserHelper.canParse((BufferedInputStream)inputStream, (TagClass)TagClass.UNIVERSAL, (int)UniversalTagNumber.INTEGER.getIntValue());
    }

    private void parseValidationParams(BufferedInputStream inputStream) {
        ((X509DhParameters)this.encodable).getValidationParms().getParser(this.chooser).parse(inputStream);
        ((X509DhParameters)this.encodable).getValidationParms().getHandler(this.chooser).adjustContextAfterParse();
    }

    private void parseJ(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1Integer((Asn1Integer)((X509DhParameters)this.encodable).getJ(), (BufferedInputStream)inputStream);
        LOGGER.debug("Parsed J: {}", ((X509DhParameters)this.encodable).getJ().getValue().getValue());
    }

    private void parseQ(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1Integer((Asn1Integer)((X509DhParameters)this.encodable).getQ(), (BufferedInputStream)inputStream);
        LOGGER.debug("Parsed Q: {}", ((X509DhParameters)this.encodable).getQ().getValue().getValue());
    }

    private void parseG(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1Integer((Asn1Integer)((X509DhParameters)this.encodable).getG(), (BufferedInputStream)inputStream);
        LOGGER.debug("Parsed G (generator): {}", ((X509DhParameters)this.encodable).getG().getValue().getValue());
    }

    private void parseP(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1Integer((Asn1Integer)((X509DhParameters)this.encodable).getP(), (BufferedInputStream)inputStream);
        LOGGER.debug("Parsed P (modulus): {}", ((X509DhParameters)this.encodable).getP().getValue().getValue());
    }
}

