/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.parser;

import de.rub.nds.asn1.model.Asn1BitString;
import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.asn1.parser.Asn1Parser;
import de.rub.nds.asn1.parser.ParserHelper;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.x509.model.publickey.PublicKeyBitString;
import de.rub.nds.x509attacker.x509.parser.X509Parser;
import java.io.BufferedInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PublicKeyBitStringParser
extends Asn1Parser<PublicKeyBitString>
implements X509Parser {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PublicKeyBitString publicKeyBitString;
    private final X509Chooser chooser;

    public PublicKeyBitStringParser(X509Chooser chooser, PublicKeyBitString publicKeyBitString) {
        super((Asn1Encodable)publicKeyBitString);
        this.publicKeyBitString = publicKeyBitString;
        this.chooser = chooser;
    }

    @Override
    public void parse(BufferedInputStream inputStream) {
        LOGGER.debug("Parsing PublicKeyBitString");
        ParserHelper.parseAsn1BitString((Asn1BitString)this.publicKeyBitString, (BufferedInputStream)inputStream);
        LOGGER.debug("PublicKey content: {}", (Object)DataConverter.bytesToHexString((byte[])((byte[])this.publicKeyBitString.getUsedBits().getValue())));
        this.publicKeyBitString.setX509PublicKeyContent(this.publicKeyBitString.createX509PublicKeyContent(this.chooser.getSubjectPublicKeyType()));
        this.publicKeyBitString.getX509PublicKeyContent().readIn(this.chooser, (byte[])this.publicKeyBitString.getUsedBits().getValue());
        this.publicKeyBitString.getX509PublicKeyContent().adjustInContext(this.chooser);
    }
}

