/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.parser;

import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.model.Asn1UnknownField;
import de.rub.nds.asn1.parser.ParserHelper;
import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.constants.DirectoryStringChoiceType;
import de.rub.nds.x509attacker.constants.X500AttributeType;
import de.rub.nds.x509attacker.x509.model.AttributeTypeAndValue;
import de.rub.nds.x509attacker.x509.model.DirectoryString;
import de.rub.nds.x509attacker.x509.parser.X509ComponentContainerParser;
import java.io.BufferedInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttributeTypeAndValueParser
extends X509ComponentContainerParser<AttributeTypeAndValue> {
    private static final Logger LOGGER = LogManager.getLogger();

    public AttributeTypeAndValueParser(X509Chooser chooser, AttributeTypeAndValue attributeTypeAndValue) {
        super(chooser, attributeTypeAndValue);
    }

    @Override
    protected void parseSubcomponents(BufferedInputStream inputStream) {
        LOGGER.debug("Parsing AttributeTypeAndValue");
        this.parseType(inputStream);
        X500AttributeType attributeType = this.getAttributeType();
        LOGGER.debug("AttributeType: {} ({})", ((AttributeTypeAndValue)this.encodable).getType().getValue().getValue(), (Object)(attributeType != null ? attributeType.name() : "unknown"));
        if (attributeType == null) {
            LOGGER.debug("AttributeType is unknown. Parsing as unknown field.");
            Asn1UnknownField unknownField = ParserHelper.parseUnknown((BufferedInputStream)inputStream);
            ((AttributeTypeAndValue)this.encodable).setValue((Asn1Encodable)unknownField);
        } else {
            switch (attributeType) {
                case COMMON_NAME: 
                case LOCALITY: 
                case STATE_OR_PROVINCE_NAME: 
                case ORGANISATION_NAME: 
                case ORGANISATION_UNIT_NAME: 
                case COUNTRY_NAME: {
                    ((AttributeTypeAndValue)this.encodable).setAttributeTypeConfig(attributeType);
                    this.parseDirectoryString(inputStream, attributeType);
                    break;
                }
                default: {
                    throw new ParserException(String.format("Did not anticipate X509AttributeType: %s", attributeType.toString()));
                }
            }
        }
    }

    private void parseDirectoryString(BufferedInputStream inputStream, X500AttributeType attributeType) {
        LOGGER.debug("Parsing: {} as DirectoryString", (Object)attributeType.toString());
        DirectoryString directoryString = new DirectoryString("string");
        directoryString.getParser(this.chooser).parse(inputStream);
        directoryString.setDirectoryStringChoiceType(DirectoryStringChoiceType.fromChoice(directoryString.getSelectedChoice()));
        directoryString.getHandler(this.chooser).adjustContextAfterParse();
        ((AttributeTypeAndValue)this.encodable).setValue(directoryString);
    }

    private X500AttributeType getAttributeType() {
        X500AttributeType attributeType = X500AttributeType.decodeFromOidBytes(((AttributeTypeAndValue)this.encodable).getType().getValueAsOid().getEncoded());
        return attributeType;
    }

    private void parseType(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1ObjectIdentifier((Asn1ObjectIdentifier)((AttributeTypeAndValue)this.encodable).getType(), (BufferedInputStream)inputStream);
        LOGGER.debug("Parsed Type: {}", ((AttributeTypeAndValue)this.encodable).getType().getValue().getValue());
    }
}

