/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.ReceiveTillLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.CommonReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.LinkedList;
import java.util.List;

@XmlRootElement(name="ReceiveTill")
public class ReceiveTillAction
extends CommonReceiveAction {
    @HoldsModifiableVariable
    @XmlElementRef
    protected ProtocolMessage waitTillMessage;

    public ReceiveTillAction() {
    }

    public ReceiveTillAction(String connectionAlias) {
        super(connectionAlias);
    }

    public ReceiveTillAction(ProtocolMessage waitTillMessage) {
        this.waitTillMessage = waitTillMessage;
    }

    public ReceiveTillAction(String connectionAliasAlias, ProtocolMessage waitTillMessage) {
        super(connectionAliasAlias);
        this.waitTillMessage = waitTillMessage;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WaitTillReceive Action:\n");
        sb.append("Waiting till:");
        if (this.waitTillMessage != null) {
            sb.append(this.waitTillMessage.toCompactString());
        } else {
            sb.append(" (no messages set)");
        }
        sb.append("\n\tActual:");
        if (this.getReceivedMessages() != null && !this.getReceivedMessages().isEmpty()) {
            for (ProtocolMessage message : this.getReceivedMessages()) {
                sb.append(message.toCompactString());
                sb.append(", ");
            }
        } else {
            sb.append(" (no messages set)");
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder(super.toCompactString());
        if (this.waitTillMessage != null) {
            sb.append(" (");
            sb.append(this.waitTillMessage.toCompactString());
            if (sb.lastIndexOf(",") > 0) {
                sb.deleteCharAt(sb.lastIndexOf(","));
            }
            sb.append(")");
        } else {
            sb.append(" (no messages set)");
        }
        return sb.toString();
    }

    @Override
    public boolean executedAsPlanned() {
        if (this.getReceivedMessages() == null) {
            return false;
        }
        for (ProtocolMessage message : this.getReceivedMessages()) {
            if (!message.getClass().equals(this.waitTillMessage.getClass())) continue;
            return true;
        }
        return false;
    }

    public ProtocolMessage getWaitTillMessage() {
        return this.waitTillMessage;
    }

    public void setWaitTillMessage(ProtocolMessage waitTillMessage) {
        this.waitTillMessage = waitTillMessage;
    }

    @Override
    protected List<LayerConfiguration<?>> createLayerConfiguration(State state) {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        LinkedList configurationList = new LinkedList();
        configurationList.add(new ReceiveTillLayerConfiguration((LayerType)ImplementedLayers.SSL2, new DataContainer[]{this.waitTillMessage}));
        configurationList.add(new ReceiveTillLayerConfiguration((LayerType)ImplementedLayers.MESSAGE, (DataContainer[])new ProtocolMessage[]{this.waitTillMessage}));
        return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), false, this.getActionOptions(), configurationList);
    }
}

