/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.ReceiveTillLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.SpecificReceiveLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacket;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.CommonReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

@XmlRootElement
public class ReceiveQuicTillAction
extends CommonReceiveAction {
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<QuicFrame> expectedQuicFrames = null;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<QuicPacket> expectedQuicPackets = null;

    public ReceiveQuicTillAction() {
    }

    public ReceiveQuicTillAction(QuicFrame ... expectedQuicFrames) {
        this.expectedQuicFrames = new ArrayList<QuicFrame>(Arrays.asList(expectedQuicFrames));
    }

    public ReceiveQuicTillAction(QuicPacket ... expectedQuicPackets) {
        this.expectedQuicPackets = new ArrayList<QuicPacket>(Arrays.asList(expectedQuicPackets));
    }

    public ReceiveQuicTillAction(ActionOption actionOption, QuicFrame ... expectedQuicFrames) {
        super(Set.of(actionOption));
        this.expectedQuicFrames = new ArrayList<QuicFrame>(Arrays.asList(expectedQuicFrames));
    }

    public ReceiveQuicTillAction(ActionOption actionOption, QuicPacket ... expectedQuicPackets) {
        super(Set.of(actionOption));
        this.expectedQuicPackets = new ArrayList<QuicPacket>(Arrays.asList(expectedQuicPackets));
    }

    public ReceiveQuicTillAction(ActionOption actionOption, List<QuicFrame> expectedQuicFrames, List<QuicPacket> expectedQuicPackets) {
        super(Set.of(actionOption));
        this.expectedQuicFrames = expectedQuicFrames;
        this.expectedQuicPackets = expectedQuicPackets;
    }

    public ReceiveQuicTillAction(Set<ActionOption> actionOptions, List<QuicFrame> expectedQuicFrames, List<QuicPacket> expectedQuicPackets) {
        super(actionOptions);
        this.expectedQuicFrames = expectedQuicFrames;
        this.expectedQuicPackets = expectedQuicPackets;
    }

    public List<QuicFrame> getExpectedQuicFrames() {
        return this.expectedQuicFrames;
    }

    public void setExpectedQuicFrames(List<QuicFrame> expectedQuicFrames) {
        this.expectedQuicFrames = expectedQuicFrames;
    }

    public List<QuicPacket> getExpectedQuicPackets() {
        return this.expectedQuicPackets;
    }

    public void setExpectedQuicPackets(List<QuicPacket> expectedQuicPackets) {
        this.expectedQuicPackets = expectedQuicPackets;
    }

    @Override
    protected List<LayerConfiguration<?>> createLayerConfiguration(State state) {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        LinkedList configurationList = new LinkedList();
        if (this.expectedQuicFrames != null) {
            configurationList.add(new ReceiveTillLayerConfiguration<QuicFrame>((LayerType)ImplementedLayers.QUICFRAME, this.expectedQuicFrames));
        }
        if (this.expectedQuicPackets != null) {
            configurationList.add(new SpecificReceiveLayerConfiguration<QuicPacket>((LayerType)ImplementedLayers.QUICPACKET, this.expectedQuicPackets));
        }
        return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), false, this.getActionOptions(), configurationList);
    }
}

