/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="PopBufferedMessage")
public class PopBufferedMessageAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean couldPop = false;

    public PopBufferedMessageAction() {
    }

    public PopBufferedMessageAction(String connectionAlias) {
        super(connectionAlias);
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TlsContext context = state.getTlsContext(this.getConnectionAlias());
        if (context.getMessageBuffer().isEmpty()) {
            LOGGER.warn("Could not pop message from buffer, buffer is empty");
            this.couldPop = false;
        } else {
            LOGGER.info("Popping message from buffer");
            context.getMessageBuffer().pop();
            this.couldPop = true;
        }
        this.setExecuted(Boolean.TRUE);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted() && this.couldPop;
    }

    @Override
    public void reset() {
        this.couldPop = false;
        this.setExecuted(false);
    }
}

