/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.connection.AliasedConnection;
import de.rub.nds.tlsattacker.core.http.HttpMessage;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2Message;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacket;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MessageActionFactory {
    public static MessageAction createTLSAction(Config tlsConfig, AliasedConnection connection, ConnectionEndType sendingConnectionEndType, ProtocolMessage ... protocolMessages) {
        return MessageActionFactory.createTLSAction(tlsConfig, connection, sendingConnectionEndType, new ArrayList<ProtocolMessage>(Arrays.asList(protocolMessages)));
    }

    public static MessageAction createSSL2Action(Config tlsConfig, AliasedConnection connection, ConnectionEndType sendingConnectionEndType, SSL2Message ... ssl2Messages) {
        return MessageActionFactory.createSSL2Action(tlsConfig, connection, sendingConnectionEndType, new ArrayList<SSL2Message>(Arrays.asList(ssl2Messages)));
    }

    public static MessageAction createHttpAction(Config tlsConfig, AliasedConnection connection, ConnectionEndType sendingConnectionEndType, HttpMessage ... httpMessages) {
        MessageAction action;
        if (connection.getLocalConnectionEndType() == sendingConnectionEndType) {
            action = new SendAction(httpMessages);
        } else {
            action = new ReceiveAction(httpMessages);
            action.setActionOptions(MessageActionFactory.getFactoryReceiveActionOptions(tlsConfig));
        }
        action.setConnectionAlias(connection.getAlias());
        return action;
    }

    public static MessageAction createTLSAction(Config tlsConfig, AliasedConnection connection, ConnectionEndType sendingConnectionEnd, List<ProtocolMessage> protocolMessages) {
        MessageAction action = connection.getLocalConnectionEndType() == sendingConnectionEnd ? new SendAction(protocolMessages) : new ReceiveAction(MessageActionFactory.getFactoryReceiveActionOptions(tlsConfig), protocolMessages);
        action.setConnectionAlias(connection.getAlias());
        return action;
    }

    public static MessageAction createSSL2Action(Config tlsConfig, AliasedConnection connection, ConnectionEndType sendingConnectionEnd, List<SSL2Message> ssl2Messages) {
        MessageAction action = connection.getLocalConnectionEndType() == sendingConnectionEnd ? new SendAction(ssl2Messages.toArray(new SSL2Message[ssl2Messages.size()])) : new ReceiveAction(MessageActionFactory.getFactoryReceiveActionOptions(tlsConfig), ssl2Messages.toArray(new SSL2Message[ssl2Messages.size()]));
        action.setConnectionAlias(connection.getAlias());
        return action;
    }

    public static MessageAction createQuicAction(Config tlsConfig, AliasedConnection connection, ConnectionEndType sendingConnectionEnd, QuicFrame ... quicFrames) {
        MessageAction action;
        if (connection.getLocalConnectionEndType() == sendingConnectionEnd) {
            action = new SendAction(quicFrames);
        } else {
            action = new ReceiveAction(quicFrames);
            action.setActionOptions(MessageActionFactory.getFactoryReceiveActionOptions(tlsConfig));
        }
        action.setConnectionAlias(connection.getAlias());
        return action;
    }

    public static MessageAction createQuicAction(Config tlsConfig, AliasedConnection connection, ConnectionEndType sendingConnectionEnd, QuicPacket ... quicPackets) {
        MessageAction action;
        if (connection.getLocalConnectionEndType() == sendingConnectionEnd) {
            action = new SendAction(quicPackets);
        } else {
            action = new ReceiveAction(quicPackets);
            action.setActionOptions(MessageActionFactory.getFactoryReceiveActionOptions(tlsConfig));
        }
        action.setConnectionAlias(connection.getAlias());
        return action;
    }

    public static MessageAction createQuicAction(Config tlsConfig, AliasedConnection connection, ConnectionEndType sendingConnectionEnd, List<QuicFrame> quicFrames, List<QuicPacket> quicPackets) {
        MessageAction action = connection.getLocalConnectionEndType() == sendingConnectionEnd ? new SendAction(null, quicFrames, quicPackets) : new ReceiveAction(MessageActionFactory.getFactoryReceiveActionOptions(tlsConfig), quicFrames, quicPackets);
        action.setConnectionAlias(connection.getAlias());
        return action;
    }

    private static Set<ActionOption> getFactoryReceiveActionOptions(Config tlsConfig) {
        HashSet<ActionOption> globalOptions = new HashSet<ActionOption>();
        if (tlsConfig.getMessageFactoryActionOptions().contains((Object)ActionOption.CHECK_ONLY_EXPECTED)) {
            globalOptions.add(ActionOption.CHECK_ONLY_EXPECTED);
        }
        if (tlsConfig.getMessageFactoryActionOptions().contains((Object)ActionOption.IGNORE_UNEXPECTED_WARNINGS)) {
            globalOptions.add(ActionOption.IGNORE_UNEXPECTED_WARNINGS);
        }
        if (tlsConfig.getMessageFactoryActionOptions().contains((Object)ActionOption.IGNORE_ACK_MESSAGES)) {
            globalOptions.add(ActionOption.IGNORE_ACK_MESSAGES);
        }
        if (tlsConfig.getMessageFactoryActionOptions().contains((Object)ActionOption.IGNORE_UNEXPECTED_NEW_SESSION_TICKETS)) {
            globalOptions.add(ActionOption.IGNORE_UNEXPECTED_NEW_SESSION_TICKETS);
        }
        return globalOptions;
    }

    private MessageActionFactory() {
    }
}

