/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TcpContext;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.AsciiAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="GenericReceiveAscii")
public class GenericReceiveAsciiAction
extends AsciiAction {
    private static final Logger LOGGER = LogManager.getLogger();

    GenericReceiveAsciiAction() {
    }

    public GenericReceiveAsciiAction(String encoding) {
        super(encoding);
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TcpContext tcpContext = state.getTcpContext();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        try {
            LOGGER.debug("Receiving ASCII message...");
            byte[] fetchData = tcpContext.getTransportHandler().fetchData();
            this.setAsciiText(new String(fetchData, this.getEncoding()));
            LOGGER.info("Received: {}", (Object)this.getAsciiText());
            this.setExecuted(true);
        }
        catch (IOException e) {
            LOGGER.debug((Object)e);
            this.setExecuted(false);
        }
    }

    @Override
    public void reset() {
        this.setExecuted(null);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }
}

