/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerStackProcessingResult;
import de.rub.nds.tlsattacker.core.layer.SpecificReceiveLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.SpecificSendLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.CommonForwardAction;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

@XmlRootElement(name="ForwardMessages")
public class ForwardMessagesAction
extends CommonForwardAction {
    @XmlElementWrapper
    @HoldsModifiableVariable
    @XmlElementRef
    protected List<ProtocolMessage> expectedMessages;

    public ForwardMessagesAction() {
    }

    public ForwardMessagesAction(String receiveFromAlias, String forwardToAlias, List<ProtocolMessage> messages) {
        this.expectedMessages = messages;
        this.receiveFromAlias = receiveFromAlias;
        this.forwardToAlias = forwardToAlias;
    }

    public ForwardMessagesAction(String receiveFromAlias, String forwardToAlias, ProtocolMessage ... messages) {
        this(receiveFromAlias, forwardToAlias, new ArrayList<ProtocolMessage>(Arrays.asList(messages)));
    }

    public List<ProtocolMessage> getExpectedMessages() {
        return this.expectedMessages;
    }

    public void setExpectedMessages(List<ProtocolMessage> messages) {
        this.expectedMessages = messages;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Forward Messages Action:\n");
        sb.append("Receive from alias: ").append(this.receiveFromAlias).append("\n");
        sb.append("\tExpected:");
        if (this.expectedMessages != null) {
            for (ProtocolMessage message : this.expectedMessages) {
                sb.append(", ");
                sb.append(message.toCompactString());
            }
        } else {
            sb.append(" (no messages set)");
        }
        sb.append("\n\tActual:");
        if (this.getReceivedMessages() != null && !this.getReceivedMessages().isEmpty()) {
            for (ProtocolMessage message : this.getReceivedMessages()) {
                sb.append(message.toCompactString());
                sb.append(", ");
            }
        } else {
            sb.append(" (no messages set)");
        }
        sb.append("\n");
        sb.append("Forwarded to alias: ").append(this.forwardToAlias).append("\n");
        if (this.getSentMessages() != null) {
            sb.append("\t");
            for (ProtocolMessage message : this.getSentMessages()) {
                sb.append(message.toCompactString());
                sb.append(", ");
            }
            sb.append("\n");
        } else {
            sb.append("null (no messages set)");
        }
        return sb.toString();
    }

    @Override
    protected List<LayerConfiguration<?>> createReceiveConfiguration(State state) {
        TlsContext tlsContext = state.getTlsContext(this.getReceiveFromAlias());
        LinkedList configurationList = new LinkedList();
        configurationList.add(new SpecificReceiveLayerConfiguration<ProtocolMessage>((LayerType)ImplementedLayers.MESSAGE, this.expectedMessages));
        return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), false, this.getActionOptions(), configurationList);
    }

    @Override
    protected List<LayerConfiguration<?>> createSendConfiguration(State state, LayerStackProcessingResult receivedResult) {
        TlsContext tlsContext = state.getTlsContext(this.getForwardToAlias());
        List<ProtocolMessage> receivedMessages = this.getReceivedMessages();
        for (ProtocolMessage message : receivedMessages) {
            message.setShouldPrepareDefault(false);
        }
        LinkedList configurationList = new LinkedList();
        configurationList.add(new SpecificSendLayerConfiguration<ProtocolMessage>((LayerType)ImplementedLayers.MESSAGE, receivedMessages));
        return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), true, this.getActionOptions(), configurationList);
    }
}

