/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.util.Modifiable;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.layer.hints.RecordLayerHint;
import de.rub.nds.tlsattacker.core.protocol.handler.ClientKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.RSAClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="EarlyCcs")
public class EarlyCcsAction
extends TlsAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Boolean targetOpenssl100;
    private boolean executedAsPlanned = false;

    public EarlyCcsAction(Boolean targetsOpenssl100) {
        this.targetOpenssl100 = targetsOpenssl100;
    }

    private EarlyCcsAction() {
        this.targetOpenssl100 = false;
    }

    @Override
    public void execute(State state) {
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(state.getConfig());
        ClientKeyExchangeMessage message = factory.createClientKeyExchangeMessage(state.getTlsContext().getChooser().getSelectedCipherSuite().getKeyExchangeAlgorithm());
        if (message == null) {
            message = new RSAClientKeyExchangeMessage();
        }
        if (!this.targetOpenssl100.booleanValue()) {
            message.setIncludeInDigest(Modifiable.explicit((Boolean)false));
        }
        message.setAdjustContext(Modifiable.explicit((Boolean)false));
        ClientKeyExchangeHandler handler = (ClientKeyExchangeHandler)message.getHandler(state.getContext());
        message.getPreparator(state.getContext()).prepare();
        if (this.targetOpenssl100.booleanValue()) {
            handler.adjustPremasterSecret(message);
            handler.adjustMasterSecret(message);
        }
        byte[] serialized = message.getSerializer(state.getContext()).serialize();
        handler.adjustContextAfterSerialize(message);
        try {
            state.getTlsContext().getRecordLayer().sendData(new RecordLayerHint(ProtocolMessageType.HANDSHAKE), serialized);
            this.executedAsPlanned = true;
        }
        catch (IOException e) {
            LOGGER.debug("Could not write Data to stream", (Throwable)e);
            this.executedAsPlanned = false;
        }
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.setExecuted(false);
        this.executedAsPlanned = false;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.executedAsPlanned;
    }
}

