/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.constants.SSL2MessageType;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2Message;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.quic.constants.QuicFrameType;
import de.rub.nds.tlsattacker.core.quic.constants.QuicPacketType;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacket;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceivingAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;

public class WorkflowTraceResultUtil {
    public static QuicFrame getFirstReceivedQuicFrame(WorkflowTrace trace, QuicFrameType type) {
        List<QuicFrame> frameList = WorkflowTraceResultUtil.getAllReceivedQuicFrames(trace);
        if ((frameList = WorkflowTraceResultUtil.filterQuicFrameList(frameList, type)).isEmpty()) {
            return null;
        }
        return frameList.get(0);
    }

    public static QuicPacket getFirstReceivedQuicPacket(WorkflowTrace trace, QuicPacketType type) {
        List<QuicPacket> packetList = WorkflowTraceResultUtil.getAllReceivedQuicPackets(trace);
        if ((packetList = WorkflowTraceResultUtil.filterQuicPacketList(packetList, type)).isEmpty()) {
            return null;
        }
        return packetList.get(0);
    }

    public static ProtocolMessage getFirstReceivedMessage(WorkflowTrace trace, ProtocolMessageType type) {
        List<ProtocolMessage> messageList = WorkflowTraceResultUtil.getAllReceivedMessages(trace);
        if ((messageList = WorkflowTraceResultUtil.filterMessageList(messageList, type)).isEmpty()) {
            return null;
        }
        return messageList.get(0);
    }

    public static SSL2Message getFirstReceivedMessage(WorkflowTrace trace, SSL2MessageType type) {
        List<SSL2Message> messageList = WorkflowTraceResultUtil.getAllReceivedSSL2Messages(trace);
        if ((messageList = WorkflowTraceResultUtil.filterMessageList(messageList, type)).isEmpty()) {
            return null;
        }
        return messageList.get(0);
    }

    public static HandshakeMessage getFirstReceivedMessage(WorkflowTrace trace, HandshakeMessageType type) {
        List<ProtocolMessage> messageList = WorkflowTraceResultUtil.getAllReceivedMessages(trace);
        List<HandshakeMessage> handshakeMessageList = WorkflowTraceResultUtil.filterHandshakeMessagesFromList(messageList);
        if ((handshakeMessageList = WorkflowTraceResultUtil.filterMessageList(handshakeMessageList, type)).isEmpty()) {
            return null;
        }
        return handshakeMessageList.get(0);
    }

    public static HandshakeMessage getLastReceivedMessage(WorkflowTrace trace, HandshakeMessageType type) {
        List<ProtocolMessage> messageList = WorkflowTraceResultUtil.getAllReceivedMessages(trace);
        List<HandshakeMessage> handshakeMessageList = WorkflowTraceResultUtil.filterHandshakeMessagesFromList(messageList);
        if ((handshakeMessageList = WorkflowTraceResultUtil.filterMessageList(handshakeMessageList, type)).isEmpty()) {
            return null;
        }
        return handshakeMessageList.get(handshakeMessageList.size() - 1);
    }

    public static ProtocolMessage getLastReceivedMessage(WorkflowTrace trace, ProtocolMessageType type) {
        List<ProtocolMessage> messageList = WorkflowTraceResultUtil.getAllReceivedMessages(trace);
        if ((messageList = WorkflowTraceResultUtil.filterMessageList(messageList, type)).isEmpty()) {
            return null;
        }
        return messageList.get(messageList.size() - 1);
    }

    public static ProtocolMessage getLastReceivedMessage(WorkflowTrace trace) {
        List<ProtocolMessage> messageList = WorkflowTraceResultUtil.getAllReceivedMessages(trace);
        if (messageList.isEmpty()) {
            return null;
        }
        return messageList.get(messageList.size() - 1);
    }

    public static QuicFrame getLastReceivedQuicFrame(WorkflowTrace trace, QuicFrameType type) {
        List<QuicFrame> frameList = WorkflowTraceResultUtil.getAllReceivedQuicFrames(trace);
        if ((frameList = WorkflowTraceResultUtil.filterQuicFrameList(frameList, type)).isEmpty()) {
            return null;
        }
        return frameList.get(frameList.size() - 1);
    }

    public static QuicFrame getLastReceivedQuicFrame(WorkflowTrace trace) {
        List<QuicFrame> frameList = WorkflowTraceResultUtil.getAllReceivedQuicFrames(trace);
        if (frameList.isEmpty()) {
            return null;
        }
        return frameList.get(frameList.size() - 1);
    }

    public static QuicPacket getLastReceivedQuicPacket(WorkflowTrace trace, QuicPacketType type) {
        List<QuicPacket> packetList = WorkflowTraceResultUtil.getAllReceivedQuicPackets(trace);
        if ((packetList = WorkflowTraceResultUtil.filterQuicPacketList(packetList, type)).isEmpty()) {
            return null;
        }
        return packetList.get(packetList.size() - 1);
    }

    public static QuicPacket getLastReceivedQuicPacket(WorkflowTrace trace) {
        List<QuicPacket> packetList = WorkflowTraceResultUtil.getAllReceivedQuicPackets(trace);
        if (packetList.isEmpty()) {
            return null;
        }
        return packetList.get(packetList.size() - 1);
    }

    public static Record getLastReceivedRecord(WorkflowTrace trace) {
        List<Record> recordList = WorkflowTraceResultUtil.getAllReceivedRecords(trace);
        if (recordList.isEmpty()) {
            return null;
        }
        return recordList.get(recordList.size() - 1);
    }

    public static ProtocolMessage getFirstSentMessage(WorkflowTrace trace, ProtocolMessageType type) {
        List<ProtocolMessage> messageList = WorkflowTraceResultUtil.getAllSentMessages(trace);
        if ((messageList = WorkflowTraceResultUtil.filterMessageList(messageList, type)).isEmpty()) {
            return null;
        }
        return messageList.get(0);
    }

    public static HandshakeMessage getFirstSentMessage(WorkflowTrace trace, HandshakeMessageType type) {
        List<ProtocolMessage> messageList = WorkflowTraceResultUtil.getAllSentMessages(trace);
        List<HandshakeMessage> handshakeMessageList = WorkflowTraceResultUtil.filterHandshakeMessagesFromList(messageList);
        if ((handshakeMessageList = WorkflowTraceResultUtil.filterMessageList(handshakeMessageList, type)).isEmpty()) {
            return null;
        }
        return handshakeMessageList.get(0);
    }

    public static ExtensionMessage getFirstSentExtension(WorkflowTrace trace, ExtensionType type) {
        List<ExtensionMessage> extensionList = WorkflowTraceResultUtil.getAllSentExtensions(trace);
        if ((extensionList = WorkflowTraceResultUtil.filterExtensionList(extensionList, type)).isEmpty()) {
            return null;
        }
        return extensionList.get(0);
    }

    public static TlsAction getFirstFailedAction(WorkflowTrace trace) {
        for (TlsAction action : trace.getTlsActions()) {
            if (action.executedAsPlanned()) continue;
            return action;
        }
        return null;
    }

    public static List<HandshakeMessage> getAllSentHandshakeMessages(WorkflowTrace trace) {
        return WorkflowTraceResultUtil.filterHandshakeMessagesFromList(WorkflowTraceResultUtil.getAllSentMessages(trace));
    }

    public static List<HandshakeMessage> getAllSentHandshakeMessages(WorkflowTrace trace, HandshakeMessageType type) {
        return WorkflowTraceResultUtil.filterMessageList(WorkflowTraceResultUtil.filterHandshakeMessagesFromList(WorkflowTraceResultUtil.getAllSentMessages(trace)), type);
    }

    public static List<HandshakeMessage> getAllReceivedHandshakeMessages(WorkflowTrace trace) {
        return WorkflowTraceResultUtil.filterHandshakeMessagesFromList(WorkflowTraceResultUtil.getAllReceivedMessages(trace));
    }

    public static List<HandshakeMessage> getAllReceivedHandshakeMessages(WorkflowTrace trace, HandshakeMessageType type) {
        return WorkflowTraceResultUtil.filterMessageList(WorkflowTraceResultUtil.filterHandshakeMessagesFromList(WorkflowTraceResultUtil.getAllReceivedMessages(trace)), type);
    }

    public static List<ExtensionMessage> getAllSentExtensions(WorkflowTrace trace) {
        List<HandshakeMessage> handshakeMessageList = WorkflowTraceResultUtil.getAllSentHandshakeMessages(trace);
        LinkedList<ExtensionMessage> extensionList = new LinkedList<ExtensionMessage>();
        for (HandshakeMessage message : handshakeMessageList) {
            extensionList.addAll(message.getExtensions());
        }
        return extensionList;
    }

    public static List<ExtensionMessage> getAllReceivedExtensions(WorkflowTrace trace) {
        List<HandshakeMessage> handshakeMessageList = WorkflowTraceResultUtil.getAllReceivedHandshakeMessages(trace);
        LinkedList<ExtensionMessage> extensionList = new LinkedList<ExtensionMessage>();
        for (HandshakeMessage message : handshakeMessageList) {
            extensionList.addAll(message.getExtensions());
        }
        return extensionList;
    }

    public static HandshakeMessage getLastSentMessage(WorkflowTrace trace, HandshakeMessageType type) {
        List<ProtocolMessage> messageList = WorkflowTraceResultUtil.getAllSentMessages(trace);
        List<HandshakeMessage> handshakeMessageList = WorkflowTraceResultUtil.filterHandshakeMessagesFromList(messageList);
        if ((handshakeMessageList = WorkflowTraceResultUtil.filterMessageList(handshakeMessageList, type)).isEmpty()) {
            return null;
        }
        return handshakeMessageList.get(handshakeMessageList.size() - 1);
    }

    public static ProtocolMessage getLastSentMessage(WorkflowTrace trace, ProtocolMessageType type) {
        List<ProtocolMessage> messageList = WorkflowTraceResultUtil.getAllSentMessages(trace);
        if ((messageList = WorkflowTraceResultUtil.filterMessageList(messageList, type)).isEmpty()) {
            return null;
        }
        return messageList.get(messageList.size() - 1);
    }

    public static boolean didReceiveQuicFrame(WorkflowTrace trace, QuicFrameType type) {
        return WorkflowTraceResultUtil.getFirstReceivedQuicFrame(trace, type) != null;
    }

    public static boolean didReceiveQuicPacket(WorkflowTrace trace, QuicPacketType type) {
        return WorkflowTraceResultUtil.getFirstReceivedQuicPacket(trace, type) != null;
    }

    public static boolean didReceiveMessage(WorkflowTrace trace, ProtocolMessageType type) {
        return WorkflowTraceResultUtil.getFirstReceivedMessage(trace, type) != null;
    }

    public static boolean didReceiveMessage(WorkflowTrace trace, HandshakeMessageType type) {
        return WorkflowTraceResultUtil.getFirstReceivedMessage(trace, type) != null;
    }

    public static boolean didReceiveMessage(WorkflowTrace trace, SSL2MessageType type) {
        return WorkflowTraceResultUtil.getFirstReceivedMessage(trace, type) != null;
    }

    public static boolean didSendMessage(WorkflowTrace trace, ProtocolMessageType type) {
        return WorkflowTraceResultUtil.getFirstSentMessage(trace, type) != null;
    }

    public static boolean didSendMessage(WorkflowTrace trace, HandshakeMessageType type) {
        return WorkflowTraceResultUtil.getFirstSentMessage(trace, type) != null;
    }

    private static List<QuicFrame> filterQuicFrameList(List<QuicFrame> frame, QuicFrameType type) {
        LinkedList<QuicFrame> returnedFrames = new LinkedList<QuicFrame>();
        for (QuicFrame quicFrame : frame) {
            if (QuicFrameType.getFrameType((Byte)quicFrame.getFrameType().getValue()) != type) continue;
            returnedFrames.add(quicFrame);
        }
        return returnedFrames;
    }

    private static List<QuicPacket> filterQuicPacketList(List<QuicPacket> packet, QuicPacketType type) {
        LinkedList<QuicPacket> returnedPackets = new LinkedList<QuicPacket>();
        for (QuicPacket quicPacket : packet) {
            if (quicPacket.getPacketType() != type) continue;
            returnedPackets.add(quicPacket);
        }
        return returnedPackets;
    }

    private static List<ProtocolMessage> filterMessageList(List<ProtocolMessage> messages, ProtocolMessageType type) {
        LinkedList<ProtocolMessage> returnedMessages = new LinkedList<ProtocolMessage>();
        for (ProtocolMessage protocolMessage : messages) {
            if (protocolMessage.getProtocolMessageType() != type) continue;
            returnedMessages.add(protocolMessage);
        }
        return returnedMessages;
    }

    private static List<HandshakeMessage> filterMessageList(List<HandshakeMessage> messages, HandshakeMessageType type) {
        LinkedList<HandshakeMessage> returnedMessages = new LinkedList<HandshakeMessage>();
        for (HandshakeMessage handshakeMessage : messages) {
            if (handshakeMessage.getHandshakeMessageType() != type) continue;
            returnedMessages.add(handshakeMessage);
        }
        return returnedMessages;
    }

    private static List<SSL2Message> filterMessageList(List<SSL2Message> messages, SSL2MessageType type) {
        LinkedList<SSL2Message> returnedMessages = new LinkedList<SSL2Message>();
        for (SSL2Message ssl2Message : messages) {
            if (ssl2Message.getSsl2MessageType() != type) continue;
            returnedMessages.add(ssl2Message);
        }
        return returnedMessages;
    }

    private static List<ExtensionMessage> filterExtensionList(List<ExtensionMessage> extensions, ExtensionType type) {
        LinkedList<ExtensionMessage> resultList = new LinkedList<ExtensionMessage>();
        for (ExtensionMessage extension : extensions) {
            if (extension.getExtensionTypeConstant() != type) continue;
            resultList.add(extension);
        }
        return resultList;
    }

    private static List<HandshakeMessage> filterHandshakeMessagesFromList(List<ProtocolMessage> messages) {
        LinkedList<HandshakeMessage> returnedMessages = new LinkedList<HandshakeMessage>();
        for (ProtocolMessage protocolMessage : messages) {
            if (!(protocolMessage instanceof HandshakeMessage)) continue;
            returnedMessages.add((HandshakeMessage)protocolMessage);
        }
        return returnedMessages;
    }

    public static List<QuicFrame> getAllReceivedQuicFrames(WorkflowTrace trace) {
        LinkedList<QuicFrame> receivedFrames = new LinkedList<QuicFrame>();
        for (ReceivingAction action : trace.getReceivingActions()) {
            if (action.getReceivedQuicFrames() == null) continue;
            receivedFrames.addAll(action.getReceivedQuicFrames());
        }
        return receivedFrames;
    }

    public static List<QuicFrame> getAllReceivedQuicFramesOfType(WorkflowTrace trace, QuicFrameType type) {
        LinkedList<QuicFrame> receivedFrame = new LinkedList<QuicFrame>();
        for (QuicFrame frame : WorkflowTraceResultUtil.getAllReceivedQuicFrames(trace)) {
            if (QuicFrameType.getFrameType((Byte)frame.getFrameType().getValue()) != type) continue;
            receivedFrame.add(frame);
        }
        return receivedFrame;
    }

    public static List<QuicPacket> getAllReceivedQuicPackets(WorkflowTrace trace) {
        LinkedList<QuicPacket> receivedPackets = new LinkedList<QuicPacket>();
        for (ReceivingAction action : trace.getReceivingActions()) {
            if (action.getReceivedQuicPackets() == null) continue;
            receivedPackets.addAll(action.getReceivedQuicPackets());
        }
        return receivedPackets;
    }

    public static List<QuicPacket> getAllReceivedQuicPacketsOfType(WorkflowTrace trace, QuicPacketType type) {
        LinkedList<QuicPacket> receivedPacket = new LinkedList<QuicPacket>();
        for (QuicPacket packet : WorkflowTraceResultUtil.getAllReceivedQuicPackets(trace)) {
            if (packet.getPacketType() != type) continue;
            receivedPacket.add(packet);
        }
        return receivedPacket;
    }

    public static List<ProtocolMessage> getAllReceivedMessages(WorkflowTrace trace) {
        LinkedList<ProtocolMessage> receivedMessage = new LinkedList<ProtocolMessage>();
        for (ReceivingAction action : trace.getReceivingActions()) {
            if (action.getReceivedMessages() == null) continue;
            receivedMessage.addAll(action.getReceivedMessages());
        }
        return receivedMessage;
    }

    public static List<SSL2Message> getAllReceivedSSL2Messages(WorkflowTrace trace) {
        LinkedList<SSL2Message> receivedMessage = new LinkedList<SSL2Message>();
        for (ReceivingAction action : trace.getReceivingActions()) {
            if (action.getReceivedSSL2Messages() == null) continue;
            receivedMessage.addAll(action.getReceivedSSL2Messages());
        }
        return receivedMessage;
    }

    public static List<ProtocolMessage> getAllReceivedMessagesOfType(WorkflowTrace trace, ProtocolMessageType type) {
        LinkedList<ProtocolMessage> receivedMessage = new LinkedList<ProtocolMessage>();
        for (ProtocolMessage message : WorkflowTraceResultUtil.getAllReceivedMessages(trace)) {
            if (message.getProtocolMessageType() != type) continue;
            receivedMessage.add(message);
        }
        return receivedMessage;
    }

    public static List<ProtocolMessage> getAllSentMessages(WorkflowTrace trace) {
        LinkedList<ProtocolMessage> sentMessages = new LinkedList<ProtocolMessage>();
        for (SendingAction action : trace.getSendingActions()) {
            if (action.getSentMessages() == null) continue;
            sentMessages.addAll(action.getSentMessages());
        }
        return sentMessages;
    }

    public static Boolean didReceiveTypeBeforeType(WorkflowTrace trace, ProtocolMessageType protocolMessageType, HandshakeMessageType type) {
        List<ProtocolMessage> receivedMessages = WorkflowTraceResultUtil.getAllReceivedMessages(trace);
        for (ProtocolMessage message : receivedMessages) {
            if (message.getProtocolMessageType() == protocolMessageType) {
                return true;
            }
            if (!(message instanceof HandshakeMessage) || ((HandshakeMessage)message).getHandshakeMessageType() != type) continue;
            return false;
        }
        return false;
    }

    public static List<Record> getAllReceivedRecords(WorkflowTrace trace) {
        LinkedList<Record> receivedRecords = new LinkedList<Record>();
        for (ReceivingAction action : trace.getReceivingActions()) {
            if (action.getReceivedRecords() == null) continue;
            receivedRecords.addAll(action.getReceivedRecords());
        }
        return receivedRecords;
    }

    public static List<Record> getAllSentRecords(WorkflowTrace trace) {
        LinkedList<Record> sendRecords = new LinkedList<Record>();
        for (SendingAction action : trace.getSendingActions()) {
            if (action.getSentRecords() == null) continue;
            sendRecords.addAll(action.getSentRecords());
        }
        return sendRecords;
    }

    public static List<QuicPacket> getAllSentQuicPackets(WorkflowTrace trace) {
        LinkedList<QuicPacket> sendPackets = new LinkedList<QuicPacket>();
        for (SendingAction action : trace.getSendingActions()) {
            if (action.getSentRecords() == null) continue;
            sendPackets.addAll(action.getSentQuicPackets());
        }
        return sendPackets;
    }

    public static List<QuicFrame> getAllSentQuicFrames(WorkflowTrace trace) {
        LinkedList<QuicFrame> sentFrames = new LinkedList<QuicFrame>();
        for (SendingAction action : trace.getSendingActions()) {
            if (action.getSentRecords() == null) continue;
            sentFrames.addAll(action.getSentQuicFrames());
        }
        return sentFrames;
    }

    public static List<ReceivingAction> getActionsThatReceived(WorkflowTrace trace, ProtocolMessageType type) {
        List<ReceivingAction> receivingActions = trace.getReceivingActions();
        LinkedList<ReceivingAction> resultActions = new LinkedList<ReceivingAction>();
        block0: for (ReceivingAction action : receivingActions) {
            if (action.getReceivedMessages() == null) continue;
            for (ProtocolMessage message : action.getReceivedMessages()) {
                if (message.getProtocolMessageType() != type) continue;
                resultActions.add(action);
                continue block0;
            }
        }
        return resultActions;
    }

    public static List<SendingAction> getActionsThatSent(WorkflowTrace trace, HandshakeMessageType type) {
        List<SendingAction> sendingAction = trace.getSendingActions();
        LinkedList<SendingAction> resultActions = new LinkedList<SendingAction>();
        block0: for (SendingAction action : sendingAction) {
            if (action.getSentMessages() == null) continue;
            for (ProtocolMessage message : action.getSentMessages()) {
                HandshakeMessage handshakeMessage;
                if (!(message instanceof HandshakeMessage) || (handshakeMessage = (HandshakeMessage)message).getHandshakeMessageType() != type) continue;
                resultActions.add(action);
                continue block0;
            }
        }
        return resultActions;
    }

    public static List<SendingAction> getActionsThatSent(WorkflowTrace trace, ProtocolMessageType type) {
        List<SendingAction> sendingAction = trace.getSendingActions();
        LinkedList<SendingAction> resultActions = new LinkedList<SendingAction>();
        block0: for (SendingAction action : sendingAction) {
            if (action.getSentMessages() == null) continue;
            for (ProtocolMessage message : action.getSentMessages()) {
                if (message.getProtocolMessageType() != type) continue;
                resultActions.add(action);
                continue block0;
            }
        }
        return resultActions;
    }

    public static List<ReceivingAction> getActionsThatReceived(WorkflowTrace trace, HandshakeMessageType type) {
        List<ReceivingAction> receivingActions = trace.getReceivingActions();
        LinkedList<ReceivingAction> resultActions = new LinkedList<ReceivingAction>();
        block0: for (ReceivingAction action : receivingActions) {
            if (action.getReceivedMessages() == null) continue;
            for (ProtocolMessage message : action.getReceivedMessages()) {
                HandshakeMessage handshakeMessage;
                if (!(message instanceof HandshakeMessage) || (handshakeMessage = (HandshakeMessage)message).getHandshakeMessageType() != type) continue;
                resultActions.add(action);
                continue block0;
            }
        }
        return resultActions;
    }

    public static TlsAction getAllActionWithResult(WorkflowTrace trace, HandshakeMessageType type) {
        TlsAction receiving = WorkflowTraceResultUtil.getFirstActionThatReceived(trace, type);
        TlsAction sending = WorkflowTraceResultUtil.getFirstActionThatSent(trace, type);
        return WorkflowTraceResultUtil.getEarlierAction(trace, receiving, sending);
    }

    public static TlsAction getFirstActionWithResult(WorkflowTrace trace, ProtocolMessageType type) {
        TlsAction receiving = WorkflowTraceResultUtil.getFirstActionThatReceived(trace, type);
        TlsAction sending = WorkflowTraceResultUtil.getFirstActionThatSent(trace, type);
        return WorkflowTraceResultUtil.getEarlierAction(trace, receiving, sending);
    }

    public static TlsAction getFirstActionThatSent(WorkflowTrace trace, ProtocolMessageType type) {
        if (!WorkflowTraceResultUtil.getActionsThatSent(trace, type).isEmpty()) {
            return (TlsAction)((Object)WorkflowTraceResultUtil.getActionsThatSent(trace, type).get(0));
        }
        return null;
    }

    public static TlsAction getFirstActionThatSent(WorkflowTrace trace, HandshakeMessageType type) {
        if (!WorkflowTraceResultUtil.getActionsThatSent(trace, type).isEmpty()) {
            return (TlsAction)((Object)WorkflowTraceResultUtil.getActionsThatSent(trace, type).get(0));
        }
        return null;
    }

    public static TlsAction getFirstActionThatReceived(WorkflowTrace trace, ProtocolMessageType type) {
        if (!WorkflowTraceResultUtil.getActionsThatReceived(trace, type).isEmpty()) {
            return (TlsAction)((Object)WorkflowTraceResultUtil.getActionsThatReceived(trace, type).get(0));
        }
        return null;
    }

    public static TlsAction getFirstActionThatReceived(WorkflowTrace trace, HandshakeMessageType type) {
        if (!WorkflowTraceResultUtil.getActionsThatReceived(trace, type).isEmpty()) {
            return (TlsAction)((Object)WorkflowTraceResultUtil.getActionsThatReceived(trace, type).get(0));
        }
        return null;
    }

    public static TlsAction getLastActionWithResult(WorkflowTrace trace, HandshakeMessageType type) {
        ReceivingAction receiving = WorkflowTraceResultUtil.getLastReceivingActionForMessage(trace, type);
        SendingAction sending = WorkflowTraceResultUtil.getLastActionThatSent(trace, type);
        return WorkflowTraceResultUtil.getLaterAction(trace, (TlsAction)((Object)receiving), (TlsAction)((Object)sending));
    }

    public static TlsAction getLastActionWithResult(WorkflowTrace trace, ProtocolMessageType type) {
        ReceivingAction receiving = WorkflowTraceResultUtil.getLastReceivingActionForMessage(trace, type);
        SendingAction sending = WorkflowTraceResultUtil.getLastActionThatSent(trace, type);
        return WorkflowTraceResultUtil.getLaterAction(trace, (TlsAction)((Object)receiving), (TlsAction)((Object)sending));
    }

    public static TlsAction getLaterAction(WorkflowTrace trace, TlsAction action1, TlsAction action2) {
        if (action1 == null && action2 == null || !WorkflowTraceResultUtil.containsIdenticalAction(trace, action1) && !WorkflowTraceResultUtil.containsIdenticalAction(trace, action2)) {
            return null;
        }
        if (action1 == null || !WorkflowTraceResultUtil.containsIdenticalAction(trace, action1)) {
            return action2;
        }
        if (action2 == null || !WorkflowTraceResultUtil.containsIdenticalAction(trace, action2)) {
            return action1;
        }
        return WorkflowTraceResultUtil.indexOfIdenticalAction(trace, action1) > WorkflowTraceResultUtil.indexOfIdenticalAction(trace, action2) ? action1 : action2;
    }

    public static TlsAction getEarlierAction(WorkflowTrace trace, TlsAction action1, TlsAction action2) {
        if (action1 == null && action2 == null || !WorkflowTraceResultUtil.containsIdenticalAction(trace, action1) && !WorkflowTraceResultUtil.containsIdenticalAction(trace, action2)) {
            return null;
        }
        if (action1 == null || !WorkflowTraceResultUtil.containsIdenticalAction(trace, action1)) {
            return action2;
        }
        if (action2 == null || !WorkflowTraceResultUtil.containsIdenticalAction(trace, action2)) {
            return action1;
        }
        return WorkflowTraceResultUtil.indexOfIdenticalAction(trace, action1) < WorkflowTraceResultUtil.indexOfIdenticalAction(trace, action2) ? action1 : action2;
    }

    public static SendingAction getLastActionThatSent(WorkflowTrace trace, ProtocolMessageType type) {
        if (!WorkflowTraceResultUtil.getActionsThatSent(trace, type).isEmpty()) {
            List<SendingAction> sendActions = WorkflowTraceResultUtil.getActionsThatSent(trace, type);
            return sendActions.get(sendActions.size() - 1);
        }
        return null;
    }

    public static SendingAction getLastActionThatSent(WorkflowTrace trace, HandshakeMessageType type) {
        if (!WorkflowTraceResultUtil.getActionsThatSent(trace, type).isEmpty()) {
            List<SendingAction> sendActions = WorkflowTraceResultUtil.getActionsThatSent(trace, type);
            return sendActions.get(sendActions.size() - 1);
        }
        return null;
    }

    public static ReceivingAction getLastReceivingActionForMessage(WorkflowTrace trace, ProtocolMessageType type) {
        if (!WorkflowTraceResultUtil.getActionsThatReceived(trace, type).isEmpty()) {
            List<ReceivingAction> receiveActions = WorkflowTraceResultUtil.getActionsThatReceived(trace, type);
            return receiveActions.get(receiveActions.size() - 1);
        }
        return null;
    }

    public static ReceivingAction getLastReceivingActionForMessage(WorkflowTrace trace, HandshakeMessageType type) {
        if (!WorkflowTraceResultUtil.getActionsThatReceived(trace, type).isEmpty()) {
            List<ReceivingAction> rcvActions = WorkflowTraceResultUtil.getActionsThatReceived(trace, type);
            return rcvActions.get(rcvActions.size() - 1);
        }
        return null;
    }

    public static List<MessageAction> getMessageActionsWithUnreadBytes(@Nonnull WorkflowTrace trace) {
        LinkedList<MessageAction> messageActionsWithUnreadBytes = new LinkedList<MessageAction>();
        for (TlsAction action : trace.getTlsActions()) {
            if (!(action instanceof MessageAction) || !(action instanceof ReceivingAction) || ((MessageAction)action).getLayerStackProcessingResult() == null || !((MessageAction)action).getLayerStackProcessingResult().hasUnreadBytes()) continue;
            messageActionsWithUnreadBytes.add((MessageAction)action);
        }
        return messageActionsWithUnreadBytes;
    }

    public static boolean hasUnreadBytes(@Nonnull WorkflowTrace trace) {
        return !WorkflowTraceResultUtil.getMessageActionsWithUnreadBytes(trace).isEmpty();
    }

    public static int indexOfIdenticalAction(WorkflowTrace trace, TlsAction action) {
        if (trace.getTlsActions() != null) {
            for (int i = 0; i < trace.getTlsActions().size(); ++i) {
                if (trace.getTlsActions().get(i) != action) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean containsIdenticalAction(WorkflowTrace trace, TlsAction action) {
        if (trace.getTlsActions() != null) {
            return trace.getTlsActions().stream().anyMatch(listed -> listed == action);
        }
        return false;
    }

    private WorkflowTraceResultUtil() {
    }
}

