/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.action.StaticReceivingAction;
import de.rub.nds.tlsattacker.core.workflow.action.StaticSendingAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class WorkflowTraceConfigurationUtil {
    private WorkflowTraceConfigurationUtil() {
    }

    public static ProtocolMessage getFirstStaticConfiguredSendMessage(WorkflowTrace trace, HandshakeMessageType type) {
        List<ProtocolMessage> messageList = WorkflowTraceConfigurationUtil.getAllStaticConfiguredSendMessages(trace);
        for (ProtocolMessage message : messageList) {
            if (!(message instanceof HandshakeMessage) || ((HandshakeMessage)message).getHandshakeMessageType() != type) continue;
            return message;
        }
        return null;
    }

    public static ProtocolMessage getFirstStaticConfiguredReceiveMessage(WorkflowTrace trace, HandshakeMessageType type) {
        List<ProtocolMessage> messageList = WorkflowTraceConfigurationUtil.getAllStaticConfiguredReceiveMessages(trace);
        for (ProtocolMessage message : messageList) {
            if (!(message instanceof HandshakeMessage) || ((HandshakeMessage)message).getHandshakeMessageType() != type) continue;
            return message;
        }
        return null;
    }

    public static ProtocolMessage getFirstStaticConfiguredSendMessage(WorkflowTrace trace, ProtocolMessageType type) {
        List<ProtocolMessage> messageList = WorkflowTraceConfigurationUtil.getAllStaticConfiguredSendMessages(trace);
        for (ProtocolMessage message : messageList) {
            if (message.getProtocolMessageType() != type) continue;
            return message;
        }
        return null;
    }

    public static StaticReceivingAction getFirstStaticConfiguredReceiveAction(WorkflowTrace trace, ProtocolMessageType type) {
        List<StaticReceivingAction> actionList = trace.getStaticConfiguredReceivingActions();
        for (StaticReceivingAction action : actionList) {
            if (action.getExpectedList(ProtocolMessage.class) == null) continue;
            for (ProtocolMessage message : action.getExpectedList(ProtocolMessage.class)) {
                if (message.getProtocolMessageType() != type) continue;
                return action;
            }
        }
        return null;
    }

    public static StaticSendingAction getFirstStaticConfiguredSendAction(WorkflowTrace trace, HandshakeMessageType type) {
        List<StaticSendingAction> actionList = trace.getStaticConfiguredSendingActions();
        for (StaticSendingAction action : actionList) {
            if (action.getConfiguredList(ProtocolMessage.class) == null) continue;
            for (ProtocolMessage message : action.getConfiguredList(ProtocolMessage.class)) {
                if (!(message instanceof HandshakeMessage) || ((HandshakeMessage)message).getHandshakeMessageType() != type) continue;
                return action;
            }
        }
        return null;
    }

    public static StaticReceivingAction getFirstStaticConfiguredReceiveAction(WorkflowTrace trace, HandshakeMessageType type) {
        List<StaticReceivingAction> actionList = trace.getStaticConfiguredReceivingActions();
        for (StaticReceivingAction action : actionList) {
            for (ProtocolMessage message : action.getExpectedList(ProtocolMessage.class)) {
                if (!(message instanceof HandshakeMessage) || ((HandshakeMessage)message).getHandshakeMessageType() != type) continue;
                return action;
            }
        }
        return null;
    }

    public static StaticSendingAction getFirstStaticConfiguredSendAction(WorkflowTrace trace, ProtocolMessageType type) {
        List<StaticSendingAction> actionList = trace.getStaticConfiguredSendingActions();
        for (StaticSendingAction action : actionList) {
            for (ProtocolMessage message : action.getConfiguredList(ProtocolMessage.class)) {
                if (message.getProtocolMessageType() != type) continue;
                return action;
            }
        }
        return null;
    }

    public static ProtocolMessage getFirstStaticConfiguredReceiveMessage(WorkflowTrace trace, ProtocolMessageType type) {
        List<ProtocolMessage> messageList = WorkflowTraceConfigurationUtil.getAllStaticConfiguredReceiveMessages(trace);
        for (ProtocolMessage message : messageList) {
            if (message.getProtocolMessageType() != type) continue;
            return message;
        }
        return null;
    }

    public static HandshakeMessage getLastStaticConfiguredSendMessage(WorkflowTrace trace, HandshakeMessageType type) {
        List<ProtocolMessage> messageList = WorkflowTraceConfigurationUtil.getAllStaticConfiguredSendMessages(trace);
        LinkedList<HandshakeMessage> filteredMessageList = new LinkedList<HandshakeMessage>();
        for (ProtocolMessage message : messageList) {
            if (!(message instanceof HandshakeMessage) || ((HandshakeMessage)message).getHandshakeMessageType() != type) continue;
            filteredMessageList.add((HandshakeMessage)message);
        }
        if (filteredMessageList.isEmpty()) {
            return null;
        }
        return (HandshakeMessage)filteredMessageList.get(filteredMessageList.size() - 1);
    }

    public static HandshakeMessage getLastStaticConfiguredReceiveMessage(WorkflowTrace trace, HandshakeMessageType type) {
        List<ProtocolMessage> messageList = WorkflowTraceConfigurationUtil.getAllStaticConfiguredReceiveMessages(trace);
        for (ProtocolMessage message : messageList) {
            if (!(message instanceof HandshakeMessage) || ((HandshakeMessage)message).getHandshakeMessageType() != type) continue;
            return (HandshakeMessage)message;
        }
        return null;
    }

    public static ProtocolMessage getLastStaticConfiguredSendMessage(WorkflowTrace trace, ProtocolMessageType type) {
        List<ProtocolMessage> messageList = WorkflowTraceConfigurationUtil.getAllStaticConfiguredSendMessages(trace);
        LinkedList<ProtocolMessage> filteredMessageList = new LinkedList<ProtocolMessage>();
        for (ProtocolMessage message : messageList) {
            if (message.getProtocolMessageType() != type) continue;
            filteredMessageList.add(message);
        }
        if (filteredMessageList.isEmpty()) {
            return null;
        }
        return (ProtocolMessage)filteredMessageList.get(filteredMessageList.size() - 1);
    }

    public static ProtocolMessage getLastStaticConfiguredReceiveMessage(WorkflowTrace trace, ProtocolMessageType type) {
        List<ProtocolMessage> messageList = WorkflowTraceConfigurationUtil.getAllStaticConfiguredReceiveMessages(trace);
        LinkedList<ProtocolMessage> filteredMessageList = new LinkedList<ProtocolMessage>();
        for (ProtocolMessage message : messageList) {
            if (message.getProtocolMessageType() != type) continue;
            filteredMessageList.add(message);
        }
        if (filteredMessageList.isEmpty()) {
            return null;
        }
        return (ProtocolMessage)filteredMessageList.get(filteredMessageList.size() - 1);
    }

    public static StaticSendingAction getLastStaticConfiguredSendAction(WorkflowTrace trace, HandshakeMessageType type) {
        List<StaticSendingAction> actionList = WorkflowTraceConfigurationUtil.getStaticSendingActionsWithConfiguration(trace, type);
        if (actionList.isEmpty()) {
            return null;
        }
        return actionList.get(actionList.size() - 1);
    }

    public static StaticReceivingAction getLastStaticConfiguredReceiveAction(WorkflowTrace trace, HandshakeMessageType type) {
        List<StaticReceivingAction> actionList = WorkflowTraceConfigurationUtil.getStaticReceivingActionsWithConfiguration(trace, type);
        if (actionList.isEmpty()) {
            return null;
        }
        return actionList.get(actionList.size() - 1);
    }

    public static StaticSendingAction getLastStaticConfiguredSendAction(WorkflowTrace trace, ProtocolMessageType type) {
        List<StaticSendingAction> actionList = WorkflowTraceConfigurationUtil.getStaticSendingActionsWithConfiguration(trace, type);
        if (actionList.isEmpty()) {
            return null;
        }
        return actionList.get(actionList.size() - 1);
    }

    public static StaticReceivingAction getLastStaticConfiguredReceiveAction(WorkflowTrace trace, ProtocolMessageType type) {
        List<StaticReceivingAction> actionList = WorkflowTraceConfigurationUtil.getStaticReceivingActionsWithConfiguration(trace, type);
        if (actionList.isEmpty()) {
            return null;
        }
        return actionList.get(actionList.size() - 1);
    }

    public static List<StaticSendingAction> getStaticSendingActionsWithConfiguration(WorkflowTrace trace, HandshakeMessageType type) {
        LinkedList<StaticSendingAction> actions = new LinkedList<StaticSendingAction>();
        for (StaticSendingAction action : trace.getStaticConfiguredSendingActions()) {
            for (ProtocolMessage message : action.getConfiguredList(ProtocolMessage.class)) {
                if (!(message instanceof HandshakeMessage) || ((HandshakeMessage)message).getHandshakeMessageType() != type) continue;
                actions.add(action);
            }
        }
        return actions;
    }

    public static List<StaticReceivingAction> getStaticReceivingActionsWithConfiguration(WorkflowTrace trace, HandshakeMessageType type) {
        LinkedList<StaticReceivingAction> actions = new LinkedList<StaticReceivingAction>();
        for (StaticReceivingAction action : trace.getStaticConfiguredReceivingActions()) {
            for (ProtocolMessage message : action.getExpectedList(ProtocolMessage.class)) {
                if (!(message instanceof HandshakeMessage) || ((HandshakeMessage)message).getHandshakeMessageType() != type) continue;
                actions.add(action);
            }
        }
        return actions;
    }

    public static List<StaticSendingAction> getStaticSendingActionsWithConfiguration(WorkflowTrace trace, ProtocolMessageType type) {
        LinkedList<StaticSendingAction> actions = new LinkedList<StaticSendingAction>();
        for (StaticSendingAction action : trace.getStaticConfiguredSendingActions()) {
            for (ProtocolMessage message : action.getConfiguredList(ProtocolMessage.class)) {
                if (message.getProtocolMessageType() != type) continue;
                actions.add(action);
            }
        }
        return actions;
    }

    public static List<StaticReceivingAction> getStaticReceivingActionsWithConfiguration(WorkflowTrace trace, ProtocolMessageType type) {
        LinkedList<StaticReceivingAction> actions = new LinkedList<StaticReceivingAction>();
        for (StaticReceivingAction action : trace.getStaticConfiguredReceivingActions()) {
            for (ProtocolMessage message : action.getExpectedList(ProtocolMessage.class)) {
                if (message.getProtocolMessageType() != type) continue;
                actions.add(action);
            }
        }
        return actions;
    }

    public static List<ProtocolMessage> getStaticConfiguredSendMessages(WorkflowTrace trace, ProtocolMessageType type) {
        List<ProtocolMessage> sendMessages = WorkflowTraceConfigurationUtil.getAllStaticConfiguredSendMessages(trace);
        Iterator<ProtocolMessage> iterator = sendMessages.iterator();
        while (iterator.hasNext()) {
            ProtocolMessage message = iterator.next();
            if (message.getProtocolMessageType() == type) continue;
            iterator.remove();
        }
        return sendMessages;
    }

    public static List<ProtocolMessage> getStaticConfiguredReceiveMessages(WorkflowTrace trace, ProtocolMessageType type) {
        List<ProtocolMessage> receiveMessages = WorkflowTraceConfigurationUtil.getAllStaticConfiguredReceiveMessages(trace);
        Iterator<ProtocolMessage> iterator = receiveMessages.iterator();
        while (iterator.hasNext()) {
            ProtocolMessage message = iterator.next();
            if (message.getProtocolMessageType() == type) continue;
            iterator.remove();
        }
        return receiveMessages;
    }

    public static List<ProtocolMessage> getStaticConfiguredSendMessages(WorkflowTrace trace, HandshakeMessageType type) {
        List<ProtocolMessage> sendMessages = WorkflowTraceConfigurationUtil.getAllStaticConfiguredSendMessages(trace);
        Iterator<ProtocolMessage> iterator = sendMessages.iterator();
        while (iterator.hasNext()) {
            ProtocolMessage message = iterator.next();
            if (message instanceof HandshakeMessage) {
                if (((HandshakeMessage)message).getHandshakeMessageType() == type) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        return sendMessages;
    }

    public static List<ProtocolMessage> getStaticConfiguredReceiveMessages(WorkflowTrace trace, HandshakeMessageType type) {
        List<ProtocolMessage> receiveMessages = WorkflowTraceConfigurationUtil.getAllStaticConfiguredReceiveMessages(trace);
        Iterator<ProtocolMessage> iterator = receiveMessages.iterator();
        while (iterator.hasNext()) {
            ProtocolMessage message = iterator.next();
            if (message instanceof HandshakeMessage) {
                if (((HandshakeMessage)message).getHandshakeMessageType() == type) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        return receiveMessages;
    }

    public static List<ProtocolMessage> getAllStaticConfiguredSendMessages(WorkflowTrace trace) {
        LinkedList<ProtocolMessage> sendMessages = new LinkedList<ProtocolMessage>();
        for (StaticSendingAction action : trace.getStaticConfiguredSendingActions()) {
            List<List<DataContainer>> configuredDataContainerLists = action.getConfiguredDataContainerLists();
            for (List<DataContainer> dataContainerList : configuredDataContainerLists) {
                for (DataContainer dataContainer : dataContainerList) {
                    if (!(dataContainer instanceof ProtocolMessage)) continue;
                    sendMessages.add((ProtocolMessage)dataContainer);
                }
            }
        }
        return sendMessages;
    }

    public static List<ProtocolMessage> getAllStaticConfiguredReceiveMessages(WorkflowTrace trace) {
        LinkedList<ProtocolMessage> receiveMessages = new LinkedList<ProtocolMessage>();
        for (StaticReceivingAction action : trace.getStaticConfiguredReceivingActions()) {
            List<List<DataContainer>> configuredDataContainerLists = action.getExpectedDataContainerLists();
            for (List<DataContainer> dataContainerList : configuredDataContainerLists) {
                for (DataContainer dataContainer : dataContainerList) {
                    if (!(dataContainer instanceof ProtocolMessage)) continue;
                    receiveMessages.add((ProtocolMessage)dataContainer);
                }
            }
        }
        return receiveMessages;
    }
}

