/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.protocol.exception.ConfigurationException;
import de.rub.nds.tlsattacker.core.connection.AliasedConnection;
import de.rub.nds.tlsattacker.core.connection.InboundConnection;
import de.rub.nds.tlsattacker.core.connection.OutboundConnection;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceResultUtil;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceSerializer;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceivingAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.StaticReceivingAction;
import de.rub.nds.tlsattacker.core.workflow.action.StaticSendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="workflowTrace")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WorkflowTrace
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlElements(value={@XmlElement(type=AliasedConnection.class, name="AliasedConnection"), @XmlElement(type=InboundConnection.class, name="InboundConnection"), @XmlElement(type=OutboundConnection.class, name="OutboundConnection")})
    private List<AliasedConnection> connections = new ArrayList<AliasedConnection>();
    @HoldsModifiableVariable
    @XmlAnyElement(lax=true)
    private List<TlsAction> tlsActions = new ArrayList<TlsAction>();
    private String name = null;
    private String description = null;
    @XmlTransient
    private boolean dirty = true;

    public static WorkflowTrace copy(WorkflowTrace orig) {
        WorkflowTrace copy = null;
        List<TlsAction> origActions = orig.getTlsActions();
        try {
            String origTraceStr = WorkflowTraceSerializer.write(orig);
            ByteArrayInputStream is = new ByteArrayInputStream(origTraceStr.getBytes(StandardCharsets.UTF_8.name()));
            copy = WorkflowTraceSerializer.insecureRead(is);
        }
        catch (JAXBException | IOException | XMLStreamException ex) {
            throw new ConfigurationException("Could not copy workflow trace: ", ex);
        }
        List<TlsAction> copiedActions = copy.getTlsActions();
        for (int i = 0; i < origActions.size(); ++i) {
            copiedActions.get(i).setSingleConnectionWorkflow(origActions.get(i).isSingleConnectionWorkflow());
        }
        return copy;
    }

    public WorkflowTrace() {
        this.tlsActions = new LinkedList<TlsAction>();
    }

    public WorkflowTrace(List<AliasedConnection> cons) {
        this.connections = cons;
    }

    public void reset() {
        for (TlsAction action : this.getTlsActions()) {
            action.reset();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<TlsAction> getTlsActions() {
        return this.tlsActions;
    }

    public void addTlsAction(TlsAction action) {
        this.dirty = true;
        this.tlsActions.add(action);
    }

    public void addTlsAction(int position, TlsAction action) {
        this.dirty = true;
        this.tlsActions.add(position, action);
    }

    public void addTlsActions(TlsAction ... actions) {
        this.addTlsActions(Arrays.asList(actions));
    }

    public void addTlsActions(List<TlsAction> actions) {
        for (TlsAction action : actions) {
            this.addTlsAction(action);
        }
    }

    public TlsAction removeTlsAction(int index) {
        this.dirty = true;
        return this.tlsActions.remove(index);
    }

    public void setTlsActions(List<TlsAction> tlsActions) {
        this.dirty = true;
        this.tlsActions = tlsActions;
    }

    public void setTlsActions(TlsAction ... tlsActions) {
        this.setTlsActions(new ArrayList<TlsAction>(Arrays.asList(tlsActions)));
    }

    public List<AliasedConnection> getConnections() {
        return this.connections;
    }

    public void setConnections(List<AliasedConnection> connections) {
        this.dirty = true;
        this.connections = connections;
    }

    public void addConnection(AliasedConnection connection) {
        this.dirty = true;
        this.connections.add(connection);
    }

    public List<MessageAction> getMessageActions() {
        LinkedList<MessageAction> messageActions = new LinkedList<MessageAction>();
        for (TlsAction action : this.tlsActions) {
            if (!(action instanceof MessageAction)) continue;
            messageActions.add((MessageAction)action);
        }
        return messageActions;
    }

    public List<ReceivingAction> getReceivingActions() {
        LinkedList<ReceivingAction> receiveActions = new LinkedList<ReceivingAction>();
        for (TlsAction action : this.tlsActions) {
            if (!(action instanceof ReceivingAction)) continue;
            receiveActions.add((ReceivingAction)((Object)action));
        }
        return receiveActions;
    }

    public List<StaticReceivingAction> getStaticConfiguredReceivingActions() {
        LinkedList<StaticReceivingAction> staticConfiguredReceivingActions = new LinkedList<StaticReceivingAction>();
        for (TlsAction action : this.tlsActions) {
            if (!(action instanceof StaticReceivingAction)) continue;
            staticConfiguredReceivingActions.add((StaticReceivingAction)((Object)action));
        }
        return staticConfiguredReceivingActions;
    }

    public List<SendingAction> getSendingActions() {
        LinkedList<SendingAction> sendingActions = new LinkedList<SendingAction>();
        for (TlsAction action : this.tlsActions) {
            if (!(action instanceof SendingAction)) continue;
            sendingActions.add((SendingAction)((Object)action));
        }
        return sendingActions;
    }

    public List<StaticSendingAction> getStaticConfiguredSendingActions() {
        LinkedList<StaticSendingAction> staticConfiguredSendingActions = new LinkedList<StaticSendingAction>();
        for (TlsAction action : this.tlsActions) {
            if (!(action instanceof StaticSendingAction)) continue;
            staticConfiguredSendingActions.add((StaticSendingAction)((Object)action));
        }
        return staticConfiguredSendingActions;
    }

    public TlsAction getLastAction() {
        int size = this.tlsActions.size();
        if (size != 0) {
            return this.tlsActions.get(size - 1);
        }
        return null;
    }

    public MessageAction getLastMessageAction() {
        for (int i = this.tlsActions.size() - 1; i >= 0; --i) {
            if (!(this.tlsActions.get(i) instanceof MessageAction)) continue;
            return (MessageAction)this.tlsActions.get(i);
        }
        return null;
    }

    public SendingAction getLastSendingAction() {
        for (int i = this.tlsActions.size() - 1; i >= 0; --i) {
            if (!(this.tlsActions.get(i) instanceof SendingAction)) continue;
            return (SendingAction)((Object)this.tlsActions.get(i));
        }
        return null;
    }

    public ReceivingAction getLastReceivingAction() {
        for (int i = this.tlsActions.size() - 1; i >= 0; --i) {
            if (!(this.tlsActions.get(i) instanceof ReceivingAction)) continue;
            return (ReceivingAction)((Object)this.tlsActions.get(i));
        }
        return null;
    }

    public MessageAction getFirstMessageAction() {
        for (int i = 0; i < this.tlsActions.size(); ++i) {
            if (!(this.tlsActions.get(i) instanceof MessageAction)) continue;
            return (MessageAction)this.tlsActions.get(i);
        }
        return null;
    }

    public SendingAction getFirstSendingAction() {
        for (int i = 0; i < this.tlsActions.size(); ++i) {
            if (!(this.tlsActions.get(i) instanceof SendingAction)) continue;
            return (SendingAction)((Object)this.tlsActions.get(i));
        }
        return null;
    }

    public ReceivingAction getFirstReceivingAction() {
        for (int i = 0; i < this.tlsActions.size(); ++i) {
            if (!(this.tlsActions.get(i) instanceof ReceivingAction)) continue;
            return (ReceivingAction)((Object)this.tlsActions.get(i));
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Trace Actions:");
        for (TlsAction action : this.tlsActions) {
            sb.append("\n");
            sb.append(action.toString());
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + Objects.hashCode(this.tlsActions);
        hash = 23 * hash + Objects.hashCode(this.name);
        hash = 23 * hash + Objects.hashCode(this.description);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkflowTrace other = (WorkflowTrace)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        return Objects.equals(this.tlsActions, other.tlsActions);
    }

    public boolean executedAsPlanned() {
        for (TlsAction action : this.tlsActions) {
            if (!(action.executedAsPlanned() || action.getActionOptions() != null && action.getActionOptions().contains((Object)ActionOption.MAY_FAIL))) {
                LOGGER.debug("Action {} did not execute as planned", (Object)action.toCompactString());
                return false;
            }
            LOGGER.debug("Action {} executed as planned", (Object)action.toCompactString());
        }
        return true;
    }

    public boolean allActionsExecuted() {
        for (TlsAction action : this.tlsActions) {
            if (action.isExecuted()) continue;
            return false;
        }
        return true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public <T extends TlsAction> T getFirstAction(Class<T> actionCls) {
        List<TlsAction> actions = this.getTlsActions();
        for (TlsAction action : actions) {
            if (!action.getClass().equals(actionCls)) continue;
            return (T)((TlsAction)actionCls.cast(action));
        }
        return null;
    }

    public <T extends ProtocolMessage> T getFirstReceivedMessage(Class<T> msgClass) {
        List<ProtocolMessage> messageList = WorkflowTraceResultUtil.getAllReceivedMessages(this);
        if ((messageList = messageList.stream().filter(i -> msgClass.isAssignableFrom(i.getClass())).collect(Collectors.toList())).isEmpty()) {
            return null;
        }
        return (T)messageList.get(0);
    }

    public <T extends ProtocolMessage> T getLastReceivedMessage(Class<T> msgClass) {
        List<ProtocolMessage> messageList = WorkflowTraceResultUtil.getAllReceivedMessages(this);
        if ((messageList = messageList.stream().filter(i -> msgClass.isAssignableFrom(i.getClass())).collect(Collectors.toList())).isEmpty()) {
            return null;
        }
        return (T)messageList.get(messageList.size() - 1);
    }

    public <T extends ProtocolMessage> T getFirstSentMessage(Class<T> msgClass) {
        List<ProtocolMessage> messageList = WorkflowTraceResultUtil.getAllSentMessages(this);
        if ((messageList = messageList.stream().filter(i -> msgClass.isAssignableFrom(i.getClass())).collect(Collectors.toList())).isEmpty()) {
            return null;
        }
        return (T)messageList.get(0);
    }

    public <T extends ProtocolMessage> T getLastSentMessage(Class<T> msgClass) {
        List<ProtocolMessage> messageList = WorkflowTraceResultUtil.getAllSentMessages(this);
        if ((messageList = messageList.stream().filter(i -> msgClass.isAssignableFrom(i.getClass())).collect(Collectors.toList())).isEmpty()) {
            return null;
        }
        return (T)messageList.get(messageList.size() - 1);
    }

    public List<MessageAction> getMessageActionsWithUnreadBytes() {
        return WorkflowTraceResultUtil.getMessageActionsWithUnreadBytes(this);
    }

    public boolean hasUnreadByte() {
        return WorkflowTraceResultUtil.hasUnreadBytes(this);
    }

    public static SendingAction getLastSendingAction(WorkflowTrace trace) {
        List<SendingAction> sendingActions = trace.getSendingActions();
        return sendingActions.get(sendingActions.size() - 1);
    }
}

