/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.util;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.constants.MacAlgorithm;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.constants.BulkCipherAlgorithm;
import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StaticTicketCrypto {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<MacAlgorithm, ThreadLocal<Mac>> algorithmCache = new EnumMap<MacAlgorithm, ThreadLocal<Mac>>(MacAlgorithm.class);

    private static Mac getInstance(MacAlgorithm macAlgorithm) {
        return (Mac)algorithmCache.computeIfAbsent(macAlgorithm, algo -> ThreadLocal.withInitial(() -> {
            try {
                return Mac.getInstance(macAlgorithm.getJavaName());
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.debug("Could not get Mac instance for {} (used java name: {})", (Object)macAlgorithm, (Object)macAlgorithm.getJavaName(), (Object)e);
                return null;
            }
        })).get();
    }

    public static byte[] encrypt(CipherAlgorithm cipherAlgorithm, byte[] plaintextUnpadded, byte[] key, byte[] iv) throws CryptoException {
        byte[] result;
        try {
            byte[] plaintext = StaticTicketCrypto.addPadding(plaintextUnpadded, cipherAlgorithm.getKeySize());
            Cipher cipher = Cipher.getInstance(cipherAlgorithm.getJavaName());
            BulkCipherAlgorithm bulkCipher = BulkCipherAlgorithm.getBulkCipherAlgorithm(cipherAlgorithm);
            SecretKeySpec secretKey = new SecretKeySpec(key, bulkCipher.getJavaName());
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(1, (Key)secretKey, ivSpec);
            result = cipher.doFinal(plaintext);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Error while StatePlaintext Encryption. See Debug-Log for more Information.", (Throwable)ex);
        }
        return result;
    }

    public static byte[] decrypt(CipherAlgorithm cipherAlgorithm, byte[] ciphertext, byte[] key, byte[] iv) throws CryptoException {
        byte[] result;
        try {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm.getJavaName());
            BulkCipherAlgorithm bulkCipher = BulkCipherAlgorithm.getBulkCipherAlgorithm(cipherAlgorithm);
            SecretKeySpec secretKey = new SecretKeySpec(key, bulkCipher.getJavaName());
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(2, (Key)secretKey, ivSpec);
            result = cipher.doFinal(ciphertext);
            result = StaticTicketCrypto.removePadding(result);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            LOGGER.warn("Encountered exception while encrypting the StatePlaintext with {}", (Object)cipherAlgorithm.name());
            LOGGER.debug((Object)ex);
            throw new CryptoException("Error while StatePlaintext Decryption. See Debug-Log for more Information.");
        }
        return result;
    }

    public static byte[] generateHMAC(MacAlgorithm macAlgorithm, byte[] plaintext, byte[] key) throws CryptoException {
        byte[] result;
        try {
            Mac mac = StaticTicketCrypto.getInstance(macAlgorithm);
            if (mac == null) {
                throw new NoSuchAlgorithmException();
            }
            SecretKeySpec macKey = new SecretKeySpec(key, macAlgorithm.getJavaName());
            mac.init(macKey);
            result = mac.doFinal(plaintext);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            LOGGER.warn("Encountered exception while generating the HMAC {} of an encryptedState.", (Object)macAlgorithm.name());
            LOGGER.debug((Object)ex);
            throw new CryptoException("Error while HMAC generation. See Debug-Log for more Information.");
        }
        return result;
    }

    public static boolean verifyHMAC(MacAlgorithm macAlgo, byte[] mac, byte[] plaintext, byte[] key) throws CryptoException {
        byte[] newMAC = StaticTicketCrypto.generateHMAC(macAlgo, plaintext, key);
        boolean result = Arrays.equals(mac, newMAC);
        return result;
    }

    private static byte[] addPadding(byte[] plainTextRaw, int keySize) {
        int padLen = 0xFF & keySize - plainTextRaw.length % keySize;
        byte[] padding = new byte[padLen];
        for (int i = 0; i < padLen; ++i) {
            padding[i] = padLen;
        }
        byte[] padded = DataConverter.concatenate((byte[][])new byte[][]{plainTextRaw, padding});
        return padded;
    }

    private static byte[] removePadding(byte[] result) {
        byte padLen = result[result.length - 1];
        return Arrays.copyOf(result, result.length - padLen);
    }

    private StaticTicketCrypto() {
    }
}

