/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.util;

import de.rub.nds.modifiablevariable.util.BadRandom;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.util.ConnectionHandler;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasicTlsServer
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger();
    private String[] cipherSuites = null;
    private final int port;
    private final SSLContext sslContext;
    private SSLServerSocket serverSocket;
    private volatile boolean shutdown;
    private volatile boolean closed = true;
    private volatile boolean initialized;

    public BasicTlsServer(KeyStore keyStore, String password, String protocol, int port) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        this.port = port;
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, password.toCharArray());
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        this.sslContext = SSLContext.getInstance(protocol);
        this.sslContext.init(keyManagers, trustManagers, (SecureRandom)new BadRandom());
        this.cipherSuites = this.sslContext.getServerSocketFactory().getSupportedCipherSuites();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Provider: {}", (Object)this.sslContext.getProvider());
            LOGGER.debug("Supported cipher suites ({})", (Object)this.sslContext.getServerSocketFactory().getSupportedCipherSuites().length);
            for (String c : this.sslContext.getServerSocketFactory().getSupportedCipherSuites()) {
                LOGGER.debug(" {}", (Object)c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.preSetup();
            this.closed = false;
            while (!this.shutdown) {
                try {
                    LOGGER.info("Listening on port {}...\n", (Object)this.port);
                    Socket socket = this.serverSocket.accept();
                    ConnectionHandler ch = new ConnectionHandler(socket);
                    Thread t = new Thread(ch);
                    t.start();
                }
                catch (IOException ex) {
                    LOGGER.debug(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
            this.closed = true;
        }
        catch (IOException ex) {
            LOGGER.debug(ex.getLocalizedMessage(), (Throwable)ex);
        }
        finally {
            try {
                if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                    this.serverSocket.close();
                    this.serverSocket = null;
                }
            }
            catch (IOException e) {
                LOGGER.debug((Object)e);
            }
            LOGGER.info("Shutdown complete");
        }
    }

    private void preSetup() throws IOException {
        SSLServerSocketFactory serverSocketFactory = this.sslContext.getServerSocketFactory();
        this.serverSocket = (SSLServerSocket)serverSocketFactory.createServerSocket(this.port);
        this.serverSocket.setReuseAddress(true);
        LOGGER.debug("Pre-setup successful");
        this.initialized = true;
    }

    public void shutdown() {
        this.shutdown = true;
        LOGGER.debug("Shutdown signal received");
        try {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex);
        }
    }

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public Set<ProtocolVersion> getEnabledProtocolVersions() {
        return Arrays.stream(this.serverSocket.getEnabledProtocols()).map(versionString -> {
            switch (versionString) {
                case "SSLv2": {
                    return ProtocolVersion.SSL2;
                }
                case "SSLv3": {
                    return ProtocolVersion.SSL3;
                }
                case "TLSv1": {
                    return ProtocolVersion.TLS10;
                }
                case "TLSv1.1": {
                    return ProtocolVersion.TLS11;
                }
                case "TLSv1.2": {
                    return ProtocolVersion.TLS12;
                }
                case "TLSv1.3": {
                    return ProtocolVersion.TLS13;
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public int getPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return this.port;
    }
}

