/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.state.serializer;

import de.rub.nds.tlsattacker.core.layer.data.Serializer;
import de.rub.nds.tlsattacker.core.state.SessionTicket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionTicketSerializer
extends Serializer<SessionTicket> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SessionTicket sessionTicket;

    public SessionTicketSerializer(SessionTicket sessionTicket) {
        this.sessionTicket = sessionTicket;
    }

    @Override
    protected byte[] serializeBytes() {
        LOGGER.debug("Serializing SessionTicket");
        this.writeKeyName(this.sessionTicket);
        this.writeIV(this.sessionTicket);
        this.writeEncryptedStateLength(this.sessionTicket);
        this.writeEncryptedState(this.sessionTicket);
        this.writeMAC(this.sessionTicket);
        return this.getAlreadySerialized();
    }

    private void writeKeyName(SessionTicket sessionTicket) {
        this.appendBytes((byte[])sessionTicket.getKeyName().getValue());
        LOGGER.debug("KeyName: {}", sessionTicket.getKeyName().getValue());
    }

    private void writeIV(SessionTicket sessionTicket) {
        this.appendBytes((byte[])sessionTicket.getIV().getValue());
        LOGGER.debug("IV: {}", sessionTicket.getIV().getValue());
    }

    private void writeEncryptedStateLength(SessionTicket sessionTicket) {
        this.appendInt((Integer)sessionTicket.getEncryptedStateLength().getValue(), 2);
    }

    private void writeEncryptedState(SessionTicket sessionTicket) {
        this.appendBytes((byte[])sessionTicket.getEncryptedState().getValue());
        LOGGER.debug("EncryptedState: {}", sessionTicket.getEncryptedState().getValue());
    }

    private void writeMAC(SessionTicket sessionTicket) {
        this.appendBytes((byte[])sessionTicket.getMAC().getValue());
        LOGGER.debug("MAC: {}", sessionTicket.getMAC().getValue());
    }
}

