/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.state;

import de.rub.nds.protocol.exception.ConfigurationException;
import de.rub.nds.protocol.exception.ContextHandlingException;
import de.rub.nds.tlsattacker.core.connection.Aliasable;
import de.rub.nds.tlsattacker.core.connection.AliasedConnection;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContextContainer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<String> knownAliases = new HashSet<String>();
    private final Map<String, Context> contexts = new HashMap<String, Context>();
    private final List<Context> inboundContexts = new ArrayList<Context>();
    private final List<Context> outboundContexts = new ArrayList<Context>();

    public Context getContext() {
        if (this.contexts.isEmpty()) {
            throw new ConfigurationException("No context defined.");
        }
        if (this.contexts.size() > 1) {
            throw new ConfigurationException("getContext requires an alias if multiple contexts are defined");
        }
        return this.contexts.entrySet().iterator().next().getValue();
    }

    public Context getContext(String alias) {
        Context ctx = this.contexts.get(alias);
        if (ctx == null) {
            throw new ConfigurationException("No context defined with alias '" + alias + "'.");
        }
        return ctx;
    }

    public void addContext(Context context) {
        AliasedConnection con = context.getConnection();
        String alias = con.getAlias();
        if (alias == null) {
            throw new ContextHandlingException("Connection end alias not set (null). Can't add the Context.");
        }
        if (this.containsAlias(alias)) {
            throw new ConfigurationException("Connection end alias already in use: " + alias);
        }
        this.contexts.put(alias, context);
        this.knownAliases.add(alias);
        if (con.getLocalConnectionEndType() == ConnectionEndType.SERVER) {
            LOGGER.debug("Adding context {} to inboundContexts", (Object)alias);
            this.inboundContexts.add(context);
        } else {
            LOGGER.debug("Adding context {} to outboundContexts", (Object)alias);
            this.outboundContexts.add(context);
        }
    }

    public List<Context> getAllContexts() {
        return new ArrayList<Context>(this.contexts.values());
    }

    public List<Context> getInboundContexts() {
        return this.inboundContexts;
    }

    public List<Context> getOutboundContexts() {
        return this.outboundContexts;
    }

    public boolean containsAlias(String alias) {
        return this.knownAliases.contains(alias);
    }

    public boolean containsAllAliases(Collection<? extends String> aliases) {
        return this.knownAliases.containsAll(aliases);
    }

    public boolean containsAllAliases(Aliasable aliasable) {
        return this.knownAliases.containsAll(aliasable.getAllAliases());
    }

    public boolean isEmpty() {
        return this.contexts.isEmpty();
    }

    public void clear() {
        this.contexts.clear();
        this.knownAliases.clear();
        this.inboundContexts.clear();
        this.outboundContexts.clear();
    }

    public void removeContext(String alias) {
        if (this.containsAlias(alias)) {
            Context removeMe = this.contexts.get(alias);
            this.inboundContexts.remove(removeMe);
            this.outboundContexts.remove(removeMe);
            this.contexts.remove(alias);
            this.knownAliases.remove(alias);
        } else {
            LOGGER.debug("No context with alias {} found, nothing to remove", (Object)alias);
        }
    }

    public void replaceContext(Context newContext) {
        String alias = newContext.getConnection().getAlias();
        if (!this.containsAlias(alias)) {
            throw new ConfigurationException("No Context to replace for alias " + alias);
        }
        Context replaceMe = this.contexts.get(alias);
        if (!replaceMe.getConnection().equals(newContext.getConnection())) {
            throw new ContextHandlingException("Cannot replace Context because the new Context defines another connection.");
        }
        this.removeContext(alias);
        this.addContext(newContext);
    }
}

