/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.socket;

import de.rub.nds.modifiablevariable.util.Modifiable;
import de.rub.nds.protocol.exception.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.ChangeCipherSpecMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.FinishedMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloDoneMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.KeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.UnknownExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareStoreEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.ClientHelloParser;
import de.rub.nds.tlsattacker.core.socket.EncapsulatingInputStream;
import de.rub.nds.tlsattacker.core.socket.EncapsulatingOutputStream;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.DefaultWorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceResultUtil;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveTillAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendDynamicClientKeyExchangeAction;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import de.rub.nds.tlsattacker.transport.stream.StreamTransportHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class TlsAttackerSslSocket
extends SSLSocket {
    private State state;
    private final long timeout;
    private final Config config;
    private EncapsulatingInputStream inputStream;
    private EncapsulatingOutputStream outputStream;
    private byte[] clientHelloBytes = null;

    public TlsAttackerSslSocket(Config config, String hostname, int port, long timeout, byte[] clientHelloBytes) throws IOException, UnknownHostException {
        super(hostname, port);
        this.timeout = timeout;
        this.config = config;
        this.clientHelloBytes = clientHelloBytes;
    }

    public TlsAttackerSslSocket(Config config, String hostname, int port, long timeout) throws IOException, UnknownHostException {
        super(hostname, port);
        this.timeout = timeout;
        this.config = config;
    }

    public TlsAttackerSslSocket(Config config, InetAddress ia, int port, long timeout) throws IOException {
        super(ia, port);
        this.timeout = timeout;
        this.config = config;
    }

    public TlsAttackerSslSocket(Config config, String hostname, int port, InetAddress ia, int i1, long timeout) throws IOException, UnknownHostException {
        super(hostname, port, ia, i1);
        this.timeout = timeout;
        this.config = config;
    }

    public TlsAttackerSslSocket(Config config, InetAddress ia, int port, InetAddress ia1, int i1, long timeout) throws IOException {
        super(ia, port, ia1, i1);
        this.timeout = timeout;
        this.config = config;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        String[] cipherSuites = new String[this.config.getDefaultClientSupportedCipherSuites().size()];
        for (int i = 0; i < cipherSuites.length; ++i) {
            cipherSuites[i] = this.config.getDefaultClientSupportedCipherSuites().get(i).name();
        }
        return cipherSuites;
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return new String[]{"SSL3", "TLS10", "TLS11", "TLS12", "TLS13"};
    }

    @Override
    public void setEnabledCipherSuites(String[] strings) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] getSupportedProtocols() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] getEnabledProtocols() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setEnabledProtocols(String[] strings) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SSLSession getSession() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener hl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener hl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void startHandshake() throws IOException {
        this.config.getDefaultClientConnection().setHostname(this.getInetAddress().getHostName());
        this.config.getDefaultClientConnection().setIp(this.getInetAddress().getHostAddress());
        this.config.getDefaultClientConnection().setPort(this.getPort());
        this.config.setWorkflowExecutorShouldClose(false);
        this.config.setWorkflowExecutorShouldOpen(false);
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(this.config);
        WorkflowTrace trace = factory.createTlsEntryWorkflowTrace(this.config.getDefaultClientConnection());
        ClientHelloMessage message = this.clientHelloBytes == null ? new ClientHelloMessage(this.config) : this.createClientHelloFromBytes(this.clientHelloBytes);
        trace.addTlsAction(new SendAction(message));
        trace.addTlsAction(new ReceiveTillAction(new ServerHelloMessage()));
        this.state = new State(this.config, trace);
        if (this.clientHelloBytes != null) {
            for (ExtensionType type : ExtensionType.getImplemented()) {
                this.state.getTlsContext().addProposedExtension(type);
            }
        }
        StreamTransportHandler streamTransportHandler = new StreamTransportHandler(this.timeout, ConnectionEndType.CLIENT, super.getInputStream(), super.getOutputStream());
        streamTransportHandler.initialize();
        this.state.getTlsContext().setTransportHandler((TransportHandler)streamTransportHandler);
        DefaultWorkflowExecutor executor = new DefaultWorkflowExecutor(this.state);
        ((WorkflowExecutor)executor).executeWorkflow();
        if (trace.executedAsPlanned()) {
            ServerHelloMessage msg = (ServerHelloMessage)WorkflowTraceResultUtil.getFirstReceivedMessage(trace, HandshakeMessageType.SERVER_HELLO);
            if (msg.hasTls13HelloRetryRequestRandom().booleanValue()) {
                this.config.setDefaultClientNamedGroups(this.state.getTlsContext().getSelectedGroup());
                new SendAction("client", new ChangeCipherSpecMessage(), new ClientHelloMessage(this.config)).execute(this.state);
                this.finishHandshakeTls13(trace);
            } else if (this.state.getTlsContext().getSelectedProtocolVersion() == ProtocolVersion.TLS13) {
                this.finishHandshakeTls13(trace);
            } else {
                this.finishHandshake(trace);
            }
        } else {
            throw new RuntimeException("Did not receive ServerHello");
        }
        this.inputStream = new EncapsulatingInputStream(this.state);
        this.outputStream = new EncapsulatingOutputStream(this.state);
    }

    private void finishHandshake(WorkflowTrace trace) throws RuntimeException, WorkflowExecutionException {
        ReceiveTillAction receiveTillAction;
        if (!WorkflowTraceResultUtil.didReceiveMessage(trace, HandshakeMessageType.SERVER_HELLO_DONE)) {
            receiveTillAction = new ReceiveTillAction("client", new ServerHelloDoneMessage());
            receiveTillAction.execute(this.state);
            if (!receiveTillAction.executedAsPlanned()) {
                throw new RuntimeException("Did not receive ServerHelloDone");
            }
        }
        new SendDynamicClientKeyExchangeAction("client").execute(this.state);
        new SendAction("client", new ChangeCipherSpecMessage(), new FinishedMessage()).execute(this.state);
        receiveTillAction = new ReceiveTillAction("client", new FinishedMessage());
        receiveTillAction.execute(this.state);
        if (!receiveTillAction.executedAsPlanned()) {
            throw new RuntimeException("Did not receive FinishedMessage");
        }
    }

    private void finishHandshakeTls13(WorkflowTrace trace) throws RuntimeException {
        if (!WorkflowTraceResultUtil.didReceiveMessage(trace, HandshakeMessageType.FINISHED)) {
            ReceiveTillAction receiveTillAction = new ReceiveTillAction("client", new FinishedMessage());
            receiveTillAction.execute(this.state);
            if (!receiveTillAction.executedAsPlanned()) {
                throw new RuntimeException("Did not receive Finished (TLS 1.3)");
            }
        }
        new SendAction("client", new FinishedMessage()).execute(this.state);
    }

    @Override
    public void setUseClientMode(boolean bln) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getUseClientMode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNeedClientAuth(boolean bln) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getNeedClientAuth() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setWantClientAuth(boolean bln) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getWantClientAuth() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setEnableSessionCreation(boolean bln) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getEnableSessionCreation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    private ClientHelloMessage createClientHelloFromBytes(byte[] clientHelloBytes) {
        ClientHelloMessage message = new ClientHelloMessage();
        ClientHelloParser parser = new ClientHelloParser(new ByteArrayInputStream(clientHelloBytes), this.state.getTlsContext());
        ClientHelloMessage parsedClientHelloMessage = new ClientHelloMessage();
        parser.parse(parsedClientHelloMessage);
        message.setCipherSuites(Modifiable.explicit((byte[])((byte[])parsedClientHelloMessage.getCipherSuites().getValue())));
        message.setCompressions(Modifiable.explicit((byte[])((byte[])parsedClientHelloMessage.getCompressions().getValue())));
        message.setSessionId(Modifiable.explicit((byte[])((byte[])parsedClientHelloMessage.getSessionId().getValue())));
        message.setProtocolVersion(Modifiable.explicit((byte[])((byte[])parsedClientHelloMessage.getProtocolVersion().getValue())));
        for (ExtensionMessage parsedExtension : parsedClientHelloMessage.getExtensions()) {
            if (parsedExtension instanceof KeyShareExtensionMessage) {
                LinkedList<KeyShareStoreEntry> storeEntryList = new LinkedList<KeyShareStoreEntry>();
                for (KeyShareEntry entry : ((KeyShareExtensionMessage)parsedExtension).getKeyShareList()) {
                    NamedGroup group = NamedGroup.getNamedGroup((byte[])entry.getGroup().getValue());
                    if (group.isEcGroup()) {
                        if (group == NamedGroup.ECDH_X25519) {
                            storeEntryList.add(this.config.getDefaultClientKeyStoreEntries().get(0));
                            continue;
                        }
                        throw new UnsupportedOperationException("Keyshares are weired in the current master branch - we will fix this in the next release. Sorry - needs to be added here");
                    }
                    storeEntryList.add(new KeyShareStoreEntry(group, new byte[1]));
                }
                this.config.setDefaultClientKeyStoreEntries(storeEntryList);
                KeyShareExtensionMessage recreatedKeyShareExtensionMessage = new KeyShareExtensionMessage(this.config);
                message.addExtension(recreatedKeyShareExtensionMessage);
                continue;
            }
            UnknownExtensionMessage craftedExtensionMessage = new UnknownExtensionMessage();
            craftedExtensionMessage.setExtensionBytes(Modifiable.explicit((byte[])((byte[])parsedExtension.getExtensionBytes().getValue())));
            message.addExtension(craftedExtensionMessage);
        }
        return message;
    }
}

