/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.serializer;

import de.rub.nds.tlsattacker.core.layer.data.Serializer;
import de.rub.nds.tlsattacker.core.record.Record;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordSerializer
extends Serializer<Record> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Record record;

    public RecordSerializer(Record record) {
        this.record = record;
    }

    @Override
    protected byte[] serializeBytes() {
        LOGGER.debug("Serializing Record");
        if (this.record.getUnifiedHeader() != null) {
            this.writeUnifiedHeader(this.record);
            if (this.record.getConnectionId() != null) {
                this.writeConnectionId(this.record);
            }
            this.writeEncryptedSequenceNumber(this.record);
            this.writeLength(this.record);
        } else {
            this.writeContentType(this.record);
            this.writeProtocolVersion(this.record);
            if (this.record.getEpoch() != null) {
                this.writeEpoch(this.record);
                this.writeSequenceNumber(this.record);
            }
            if (this.record.getConnectionId() != null) {
                this.writeConnectionId(this.record);
            }
            this.writeLength(this.record);
        }
        this.writeProtocolMessageBytes(this.record);
        return this.getAlreadySerialized();
    }

    private void writeUnifiedHeader(Record record) {
        this.appendByte((Byte)record.getUnifiedHeader().getValue());
        LOGGER.debug("UnifiedHeader: 00{}", (Object)Integer.toBinaryString(((Byte)record.getUnifiedHeader().getValue()).byteValue()));
    }

    private void writeEncryptedSequenceNumber(Record record) {
        this.appendBytes((byte[])record.getEncryptedSequenceNumber().getValue());
        LOGGER.debug("Encrypted SequenceNumber: {}", record.getEncryptedSequenceNumber().getValue());
    }

    private void writeContentType(Record record) {
        this.appendByte((Byte)record.getContentType().getValue());
        LOGGER.debug("ContentType: {}", record.getContentType().getValue());
    }

    private void writeProtocolVersion(Record record) {
        this.appendBytes((byte[])record.getProtocolVersion().getValue());
        LOGGER.debug("ProtocolVersion: {}", record.getProtocolVersion().getValue());
    }

    private void writeLength(Record record) {
        this.appendInt((Integer)record.getLength().getValue(), 2);
        LOGGER.debug("Length: {}", record.getLength().getValue());
    }

    private void writeConnectionId(Record record) {
        this.appendBytes((byte[])record.getConnectionId().getValue());
        LOGGER.debug("ConnectionID: {}", record.getConnectionId().getValue());
    }

    private void writeEpoch(Record record) {
        this.appendInt((Integer)record.getEpoch().getValue(), 2);
        LOGGER.debug("Epoch: {}", record.getEpoch().getValue());
    }

    private void writeSequenceNumber(Record record) {
        this.appendBigInteger((BigInteger)record.getSequenceNumber().getValue(), 6);
        LOGGER.debug("SequenceNumber: {}", record.getSequenceNumber().getValue());
    }

    private void writeProtocolMessageBytes(Record record) {
        this.appendBytes((byte[])record.getProtocolMessageBytes().getValue());
        LOGGER.debug("ProtocolMessageBytes: {}", record.getProtocolMessageBytes().getValue());
    }
}

