/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.cipher;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.crypto.cipher.CipherWrapper;
import de.rub.nds.tlsattacker.core.crypto.mac.MacWrapper;
import de.rub.nds.tlsattacker.core.crypto.mac.WrappedMac;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.RecordCryptoComputations;
import de.rub.nds.tlsattacker.core.record.cipher.CipherState;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.ByteArrayInputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordStreamCipher
extends RecordCipher {
    private static final Logger LOGGER = LogManager.getLogger();
    private WrappedMac readMac;
    private WrappedMac writeMac;

    public RecordStreamCipher(TlsContext tlsContext, CipherState state) {
        super(tlsContext, state);
        this.initCipherAndMac();
    }

    private void initCipherAndMac() throws UnsupportedOperationException {
        try {
            this.encryptCipher = CipherWrapper.getEncryptionCipher(this.getState().getCipherSuite(), this.getLocalConnectionEndType(), this.getState().getKeySet());
            this.decryptCipher = CipherWrapper.getDecryptionCipher(this.getState().getCipherSuite(), this.getLocalConnectionEndType(), this.getState().getKeySet());
            this.readMac = MacWrapper.getMac(this.getState().getVersion(), this.getState().getCipherSuite(), this.getState().getKeySet().getReadMacSecret(this.getLocalConnectionEndType()));
            this.writeMac = MacWrapper.getMac(this.getState().getVersion(), this.getState().getCipherSuite(), this.getState().getKeySet().getWriteMacSecret(this.getLocalConnectionEndType()));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException("Cipher not supported: " + this.getState().getCipherSuite().name(), ex);
        }
    }

    public byte[] calculateMac(byte[] data, ConnectionEndType connectionEndType) {
        LOGGER.debug("The MAC was calculated over the following data: {}", (Object)data);
        byte[] result = connectionEndType == this.getConnectionEndType() ? this.writeMac.calculateMac(data) : this.readMac.calculateMac(data);
        LOGGER.debug("MAC: {}", (Object)result);
        return result;
    }

    @Override
    public void encrypt(Record record) throws CryptoException {
        if (record.getComputations() == null) {
            LOGGER.warn("Record computations are not prepared.");
            record.prepareComputations();
        }
        LOGGER.debug("Encrypting Record:");
        RecordCryptoComputations computations = record.getComputations();
        computations.setMacKey(this.getState().getKeySet().getWriteMacSecret(this.getConnectionEndType()));
        computations.setCipherKey(this.getState().getKeySet().getWriteKey(this.getConnectionEndType()));
        byte[] cleanBytes = (byte[])record.getCleanProtocolMessageBytes().getValue();
        computations.setAuthenticatedNonMetaData(cleanBytes);
        record.setLength(cleanBytes.length + AlgorithmResolver.getMacAlgorithm(this.getState().getVersion(), this.getState().getCipherSuite()).getMacLength());
        computations.setAuthenticatedMetaData(this.collectAdditionalAuthenticatedData(record, this.getState().getVersion()));
        computations.setMac(this.calculateMac(DataConverter.concatenate((byte[][])new byte[][]{(byte[])computations.getAuthenticatedMetaData().getValue(), (byte[])computations.getAuthenticatedNonMetaData().getValue()}), this.getLocalConnectionEndType()));
        computations.setPlainRecordBytes(DataConverter.concatenate((byte[][])new byte[][]{(byte[])record.getCleanProtocolMessageBytes().getValue(), (byte[])computations.getMac().getValue()}));
        computations.setCiphertext(this.encryptCipher.encrypt((byte[])record.getComputations().getPlainRecordBytes().getValue()));
        record.setProtocolMessageBytes((byte[])computations.getCiphertext().getValue());
        computations.setMacValid(true);
    }

    @Override
    public void decrypt(Record record) throws CryptoException {
        if (record.getComputations() == null) {
            LOGGER.warn("Record computations are not prepared.");
            record.prepareComputations();
        }
        LOGGER.debug("Decrypting Record");
        RecordCryptoComputations computations = record.getComputations();
        computations.setMacKey(this.getState().getKeySet().getReadMacSecret(this.getConnectionEndType()));
        computations.setCipherKey(this.getState().getKeySet().getReadKey(this.getConnectionEndType()));
        byte[] cipherText = (byte[])record.getProtocolMessageBytes().getValue();
        computations.setCiphertext(cipherText);
        byte[] plainData = this.decryptCipher.decrypt(cipherText);
        computations.setPlainRecordBytes(plainData);
        plainData = (byte[])computations.getPlainRecordBytes().getValue();
        PlaintextParser parser = new PlaintextParser(this, plainData);
        try {
            byte[] cleanBytes = parser.parseByteArrayField(plainData.length - this.readMac.getMacLength());
            record.setCleanProtocolMessageBytes(cleanBytes);
            record.getComputations().setAuthenticatedNonMetaData(cleanBytes);
            record.getComputations().setAuthenticatedMetaData(this.collectAdditionalAuthenticatedData(record, this.getState().getVersion()));
            byte[] hmac = parser.parseByteArrayField(this.readMac.getMacLength());
            record.getComputations().setMac(hmac);
            byte[] calculatedHmac = this.calculateMac(DataConverter.concatenate((byte[][])new byte[][]{(byte[])record.getComputations().getAuthenticatedMetaData().getValue(), (byte[])record.getComputations().getAuthenticatedNonMetaData().getValue()}), this.getTalkingConnectionEndType());
            record.getComputations().setMacValid(Arrays.equals(hmac, calculatedHmac));
        }
        catch (ParserException e) {
            LOGGER.warn("Could not find all components (ciphertext, tag) in record.");
            LOGGER.warn("This is probably us having the wrong keys. Depending on the application this may be fine.");
            LOGGER.warn("Setting clean bytes to protocol message bytes.");
            record.setCleanProtocolMessageBytes(record.getProtocolMessageBytes());
            record.getComputations().setMacValid(false);
        }
    }

    class PlaintextParser
    extends Parser<Object> {
        public PlaintextParser(RecordStreamCipher this$0, byte[] array) {
            super(new ByteArrayInputStream(array));
        }

        @Override
        public byte[] parseByteArrayField(int length) {
            return super.parseByteArrayField(length);
        }

        @Override
        public int getBytesLeft() {
            return super.getBytesLeft();
        }

        @Override
        public void parse(Object t) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

