/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.cipher;

import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.CipherType;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.record.cipher.CipherState;
import de.rub.nds.tlsattacker.core.record.cipher.RecordAEADCipher;
import de.rub.nds.tlsattacker.core.record.cipher.RecordBlockCipher;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.core.record.cipher.RecordNullCipher;
import de.rub.nds.tlsattacker.core.record.cipher.RecordStreamCipher;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordCipherFactory {
    private static final Logger LOGGER = LogManager.getLogger();

    public static RecordCipher getRecordCipher(TlsContext tlsContext, KeySet keySet, CipherSuite cipherSuite, byte[] connectionId) {
        try {
            if (tlsContext.getChooser().getSelectedCipherSuite() == null || !cipherSuite.isImplemented()) {
                LOGGER.warn("Cipher {} not implemented. Using Null Cipher instead", (Object)cipherSuite);
                return RecordCipherFactory.getNullCipher(tlsContext);
            }
            CipherState state = new CipherState(tlsContext.getChooser().getSelectedProtocolVersion(), cipherSuite, keySet, tlsContext.isExtensionNegotiated(ExtensionType.ENCRYPT_THEN_MAC), connectionId);
            CipherType cipherType = cipherSuite.getCipherType();
            if (cipherType == null) {
                LOGGER.warn("CipherType is null. Using Null Cipher instead");
                return new RecordNullCipher(tlsContext, state);
            }
            switch (cipherType) {
                case AEAD: {
                    return new RecordAEADCipher(tlsContext, state);
                }
                case BLOCK: {
                    return new RecordBlockCipher(tlsContext, state);
                }
                case STREAM: {
                    return new RecordStreamCipher(tlsContext, state);
                }
            }
            LOGGER.warn("Unknown CipherType: {}", (Object)cipherType);
            return new RecordNullCipher(tlsContext, state);
        }
        catch (Exception e) {
            LOGGER.debug("Could not create RecordCipher from the current Context! Creating null Cipher", (Throwable)e);
            return RecordCipherFactory.getNullCipher(tlsContext);
        }
    }

    public static RecordCipher getRecordCipher(TlsContext tlsContext, KeySet keySet, boolean isForEncryption) {
        return RecordCipherFactory.getRecordCipher(tlsContext, keySet, tlsContext.getChooser().getSelectedCipherSuite(), isForEncryption ? tlsContext.getWriteConnectionId() : tlsContext.getReadConnectionId());
    }

    public static RecordNullCipher getNullCipher(TlsContext tlsContext) {
        return new RecordNullCipher(tlsContext, new CipherState(tlsContext.getChooser().getSelectedProtocolVersion(), tlsContext.getChooser().getSelectedCipherSuite(), null, null, null));
    }

    private RecordCipherFactory() {
    }
}

