/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.util;

import de.rub.nds.modifiablevariable.util.DataConverter;

public class VariableLengthIntegerEncoding {
    public static byte[] encodeVariableLengthInteger(long value) {
        byte[] result;
        if (value > EncodingLength.SIXTY_BITS.maxValue) {
            return null;
        }
        if (value <= EncodingLength.SIX_BITS.maxValue) {
            result = DataConverter.longToBytes((long)value, (int)1);
        } else if (value <= EncodingLength.FOURTEEN_BITS.maxValue) {
            result = DataConverter.longToBytes((long)value, (int)2);
            result[0] = (byte)(result[0] | 0x40);
        } else if (value <= EncodingLength.THIRTY_BITS.maxValue) {
            result = DataConverter.longToBytes((long)value, (int)4);
            result[0] = (byte)(result[0] | 0x80);
        } else {
            result = DataConverter.longToBytes((long)value, (int)8);
            result[0] = (byte)(result[0] | 0xC0);
        }
        return result;
    }

    public static long decodeVariableLengthInteger(byte[] bytes) {
        long v = bytes[0];
        byte prefix = (byte)((v & 0xFFL) >> 6);
        int length = 1 << prefix;
        v = (byte)v & 0x3F;
        for (int i = 1; i < length; ++i) {
            v = (v << 8) + (long)(bytes[i] & 0xFF);
        }
        return v;
    }

    public static enum EncodingLength {
        SIX_BITS(63L),
        FOURTEEN_BITS(16383L),
        THIRTY_BITS(0x3FFFFFFFL),
        SIXTY_BITS(0x3FFFFFFFFFFFFFFFL);

        private final long maxValue;

        private EncodingLength(long maxValue) {
            this.maxValue = maxValue;
        }

        public long getMaxValue() {
            return this.maxValue;
        }
    }
}

