/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.serializer.frame;

import de.rub.nds.tlsattacker.core.quic.frame.MaxStreamDataFrame;
import de.rub.nds.tlsattacker.core.quic.serializer.frame.QuicFrameSerializer;
import de.rub.nds.tlsattacker.core.quic.util.VariableLengthIntegerEncoding;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MaxStreamDataFrameSerializer
extends QuicFrameSerializer<MaxStreamDataFrame> {
    private static final Logger LOGGER = LogManager.getLogger();

    public MaxStreamDataFrameSerializer(MaxStreamDataFrame frame) {
        super(frame);
    }

    @Override
    protected byte[] serializeBytes() {
        this.writeFrameType();
        this.writeStreamId();
        this.writeMaximumStreamData();
        return this.getAlreadySerialized();
    }

    private void writeStreamId() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger(((Integer)((MaxStreamDataFrame)this.frame).getStreamId().getValue()).intValue()));
        LOGGER.debug("Stream ID: {}", ((MaxStreamDataFrame)this.frame).getStreamId().getValue());
    }

    protected void writeMaximumStreamData() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger(((Integer)((MaxStreamDataFrame)this.frame).getMaximumStreamData().getValue()).intValue()));
        LOGGER.debug("Maximum Stream Data: {}", ((MaxStreamDataFrame)this.frame).getMaximumStreamData().getValue());
    }
}

