/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.preparator.packet;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.layer.data.Preparator;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacket;
import de.rub.nds.tlsattacker.core.state.quic.QuicContext;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class QuicPacketPreparator<T extends QuicPacket>
extends Preparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected QuicContext context;
    protected T packet;

    public QuicPacketPreparator(Chooser chooser, T packet) {
        super(chooser, packet);
        this.packet = packet;
        this.context = chooser.getContext().getQuicContext();
    }

    protected void prepareQuicPacket() {
        this.prepareDestinationConnectionId();
        this.prepareDestinationConnectionIdLength();
        this.preparePacketNumberLength();
        this.preparePadding();
        this.prepareUnprotectedPayload();
        this.preparePacketLength();
        ((QuicPacket)this.packet).buildUnprotectedPacketHeader();
    }

    private void preparePacketLength() {
        ((QuicPacket)this.packet).setPacketLength(((byte[])((QuicPacket)this.packet).getUnprotectedPayload().getValue()).length + (Integer)((QuicPacket)this.packet).getPacketNumberLength().getValue() + 16);
        LOGGER.debug("Packet Length: {}", ((QuicPacket)this.packet).getPacketLength().getValue());
    }

    private void prepareUnprotectedPayload() {
        SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();
        outputStream.write((byte[])((QuicPacket)this.packet).getUnprotectedPayload().getValue());
        if (((QuicPacket)this.packet).getPadding() > 0) {
            outputStream.write(new byte[((QuicPacket)this.packet).getPadding()]);
        }
        ((QuicPacket)this.packet).setUnprotectedPayload(outputStream.toByteArray());
        LOGGER.debug("Unprotected Payload: {}", ((QuicPacket)this.packet).getUnprotectedPayload().getValue());
    }

    private void prepareDestinationConnectionId() {
        ((QuicPacket)this.packet).setDestinationConnectionId(this.context.getDestinationConnectionId());
        LOGGER.debug("Destination Connection ID: {}", ((QuicPacket)this.packet).getDestinationConnectionId().getValue());
    }

    private void prepareDestinationConnectionIdLength() {
        ((QuicPacket)this.packet).setDestinationConnectionIdLength((byte)((byte[])((QuicPacket)this.packet).getDestinationConnectionId().getValue()).length);
        LOGGER.debug("Destination Connection ID Length: {}", ((QuicPacket)this.packet).getDestinationConnectionIdLength().getValue());
    }

    private void preparePacketNumberLength() {
        ((QuicPacket)this.packet).setPacketNumberLength(((byte[])((QuicPacket)this.packet).getUnprotectedPacketNumber().getValue()).length);
        LOGGER.debug("Packet Number Length: {}", ((QuicPacket)this.packet).getPacketNumberLength().getValue());
    }

    private void preparePadding() {
        if (((QuicPacket)this.packet).getPadding() == 0) {
            ((QuicPacket)this.packet).setPadding(this.calculatePadding());
            LOGGER.debug("Padding: {}", (Object)((QuicPacket)this.packet).getPadding());
        }
    }

    protected int calculatePadding() {
        return Math.max(0, 100 - ((byte[])((QuicPacket)this.packet).getUnprotectedPayload().getValue()).length);
    }
}

