/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.parser.packet;

import de.rub.nds.tlsattacker.core.quic.packet.RetryPacket;
import de.rub.nds.tlsattacker.core.quic.parser.packet.LongHeaderPacketParser;
import de.rub.nds.tlsattacker.core.state.quic.QuicContext;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RetryPacketParser
extends LongHeaderPacketParser<RetryPacket> {
    private static final Logger LOGGER = LogManager.getLogger();

    public RetryPacketParser(InputStream stream, QuicContext context) {
        super(stream, context);
    }

    @Override
    public void parse(RetryPacket packet) {
        this.parseDestinationConnectionIdLength(packet);
        this.parseDestinationConnectionId(packet);
        this.parseSourceConnectionIdLength(packet);
        this.parseSourceConnectionId(packet);
        this.parseRetryToken(packet);
    }

    private void parseRetryToken(RetryPacket packet) {
        byte[] tokenAndIntegrityTag = this.parseTillEnd();
        packet.setRetryToken(Arrays.copyOfRange(tokenAndIntegrityTag, 0, tokenAndIntegrityTag.length - 16));
        LOGGER.debug("Retry Token: {}", packet.getRetryToken().getValue());
        packet.setRetryIntegrityTag(Arrays.copyOfRange(tokenAndIntegrityTag, tokenAndIntegrityTag.length - 16, tokenAndIntegrityTag.length));
        LOGGER.debug("Retry Integrity Tag: {}", packet.getRetryIntegrityTag().getValue());
    }
}

