/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.parser.frame;

import de.rub.nds.tlsattacker.core.quic.constants.QuicFrameType;
import de.rub.nds.tlsattacker.core.quic.frame.AckFrame;
import de.rub.nds.tlsattacker.core.quic.parser.frame.QuicFrameParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AckFrameParser
extends QuicFrameParser<AckFrame> {
    private static final Logger LOGGER = LogManager.getLogger();

    public AckFrameParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(AckFrame frame) {
        this.parseLargestAcknowledged(frame);
        this.parseAckDelay(frame);
        this.parseAckRangeCount(frame);
        this.parseFirstAckRange(frame);
        int i = 1;
        while ((long)i < (Long)frame.getAckRangeCount().getValue()) {
            this.parseVariableLengthInteger();
            this.parseVariableLengthInteger();
            ++i;
        }
        QuicFrameType frameType = QuicFrameType.getFrameType((Byte)frame.getFrameType().getValue());
        if (frameType == QuicFrameType.ACK_FRAME_WITH_ECN) {
            this.parseEcnCounts(frame);
        }
    }

    protected void parseLargestAcknowledged(AckFrame frame) {
        frame.setLargestAcknowledged((int)this.parseVariableLengthInteger());
        LOGGER.debug("Largest Acknowledged: {}", frame.getLargestAcknowledged().getValue());
    }

    protected void parseAckDelay(AckFrame frame) {
        frame.setAckDelay((int)this.parseVariableLengthInteger());
        LOGGER.debug("ACK Delay: {}", frame.getAckDelay().getValue());
    }

    protected void parseAckRangeCount(AckFrame frame) {
        frame.setAckRangeCount((int)this.parseVariableLengthInteger());
        LOGGER.debug("ACK Range Count: {}", frame.getAckRangeCount().getValue());
    }

    protected void parseFirstAckRange(AckFrame frame) {
        frame.setFirstACKRange((int)this.parseVariableLengthInteger());
        LOGGER.debug("First ACK Range: {}", frame.getFirstACKRange().getValue());
    }

    protected void parseEcnCounts(AckFrame frame) {
        frame.setEct0(this.parseVariableLengthInteger());
        LOGGER.debug("ECT0 Count: {}", frame.getEct0().getValue());
        frame.setEct1(this.parseVariableLengthInteger());
        LOGGER.debug("ECT1 Count: {}", frame.getEct1().getValue());
        frame.setEcnCe(this.parseVariableLengthInteger());
        LOGGER.debug("ECT-CE Count: {}", frame.getEcnCe().getValue());
    }
}

