/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.frame;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.quic.constants.QuicFrameType;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.handler.frame.MaxStreamDataFrameHandler;
import de.rub.nds.tlsattacker.core.quic.parser.frame.MaxStreamDataFrameParser;
import de.rub.nds.tlsattacker.core.quic.preparator.frame.MaxStreamDataFramePreparator;
import de.rub.nds.tlsattacker.core.quic.serializer.frame.MaxStreamDataFrameSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;

@XmlRootElement
public class MaxStreamDataFrame
extends QuicFrame {
    @ModifiableVariableProperty
    protected ModifiableInteger streamId;
    @ModifiableVariableProperty
    protected ModifiableInteger maximumStreamData;
    private int streamIdConfig;
    private int maximumStreamDataConfig;

    public MaxStreamDataFrame() {
        super(QuicFrameType.MAX_STREAM_DATA_FRAME);
    }

    public MaxStreamDataFrame(int streamIdConfig, int maximumStreamDataConfig) {
        this();
        this.streamIdConfig = streamIdConfig;
        this.maximumStreamDataConfig = maximumStreamDataConfig;
    }

    @Override
    public MaxStreamDataFrameHandler getHandler(Context context) {
        return new MaxStreamDataFrameHandler(context.getQuicContext());
    }

    @Override
    public MaxStreamDataFrameSerializer getSerializer(Context context) {
        return new MaxStreamDataFrameSerializer(this);
    }

    @Override
    public MaxStreamDataFramePreparator getPreparator(Context context) {
        return new MaxStreamDataFramePreparator(context.getChooser(), this);
    }

    @Override
    public MaxStreamDataFrameParser getParser(Context context, InputStream stream) {
        return new MaxStreamDataFrameParser(stream);
    }

    public ModifiableInteger getStreamId() {
        return this.streamId;
    }

    public void setStreamId(ModifiableInteger streamId) {
        this.streamId = streamId;
    }

    public void setStreamId(int streamId) {
        this.streamId = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.streamId, (Integer)streamId);
    }

    public ModifiableInteger getMaximumStreamData() {
        return this.maximumStreamData;
    }

    public void setMaximumStreamData(ModifiableInteger maximumStreamData) {
        this.maximumStreamData = maximumStreamData;
    }

    public void setMaximumStreamData(int maximumStreamData) {
        this.maximumStreamData = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.maximumStreamData, (Integer)maximumStreamData);
    }

    public int getStreamIdConfig() {
        return this.streamIdConfig;
    }

    public void setStreamIdConfig(int streamIdConfig) {
        this.streamIdConfig = streamIdConfig;
    }

    public int getMaximumStreamDataConfig() {
        return this.maximumStreamDataConfig;
    }

    public void setMaximumStreamDataConfig(int maximumStreamDataConfig) {
        this.maximumStreamDataConfig = maximumStreamDataConfig;
    }
}

