/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptedServerNameIndicationExtensionSerializer
extends ExtensionSerializer<EncryptedServerNameIndicationExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final EncryptedServerNameIndicationExtensionMessage msg;

    public EncryptedServerNameIndicationExtensionSerializer(EncryptedServerNameIndicationExtensionMessage message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeExtensionContent() {
        LOGGER.debug("Serializing EncryptedServerNameIndicationExtensionMessage");
        switch (this.msg.getEsniMessageTypeConfig()) {
            case CLIENT: {
                this.writeCipherSuite(this.msg);
                this.writeNamedGroup(this.msg);
                this.writeKeyExchangeLength(this.msg);
                this.writeKeyExchange(this.msg);
                this.writeRecordDigestLength(this.msg);
                this.writeRecordDigest(this.msg);
                this.writeEncryptedSniLength(this.msg);
                this.writeEncryptedSni(this.msg);
                break;
            }
            case SERVER: {
                this.writeCipherServerNonce(this.msg);
                break;
            }
        }
        return this.getAlreadySerialized();
    }

    private void writeCipherServerNonce(EncryptedServerNameIndicationExtensionMessage msg) {
        this.appendBytes((byte[])msg.getServerNonce().getValue());
        LOGGER.debug("writeServerNonce: {}", msg.getServerNonce().getValue());
    }

    private void writeCipherSuite(EncryptedServerNameIndicationExtensionMessage msg) {
        this.appendBytes((byte[])msg.getCipherSuite().getValue());
        LOGGER.debug("CipherSuite: {}", msg.getCipherSuite().getValue());
    }

    private void writeNamedGroup(EncryptedServerNameIndicationExtensionMessage msg) {
        this.appendBytes((byte[])msg.getKeyShareEntry().getGroup().getValue());
        LOGGER.debug("NamedGroup: {}", msg.getKeyShareEntry().getGroup().getValue());
    }

    private void writeKeyExchangeLength(EncryptedServerNameIndicationExtensionMessage msg) {
        this.appendInt((Integer)msg.getKeyShareEntry().getPublicKeyLength().getValue(), 2);
        LOGGER.debug("KeyExchangeLength: " + String.valueOf(msg.getKeyShareEntry().getPublicKeyLength().getValue()));
    }

    private void writeKeyExchange(EncryptedServerNameIndicationExtensionMessage msg) {
        this.appendBytes((byte[])msg.getKeyShareEntry().getPublicKey().getValue());
        LOGGER.debug("KeyKeyShareEntry: {}", msg.getKeyShareEntry().getPublicKey().getValue());
    }

    private void writeRecordDigestLength(EncryptedServerNameIndicationExtensionMessage msg) {
        this.appendInt((Integer)msg.getRecordDigestLength().getValue(), 2);
        LOGGER.debug("RecordDigestLength: {}", msg.getRecordDigestLength().getValue());
    }

    private void writeRecordDigest(EncryptedServerNameIndicationExtensionMessage msg) {
        this.appendBytes((byte[])msg.getRecordDigest().getValue());
        LOGGER.debug("RecordDigest: {}", msg.getRecordDigest().getValue());
    }

    private void writeEncryptedSniLength(EncryptedServerNameIndicationExtensionMessage msg) {
        this.appendInt((Integer)msg.getEncryptedSniLength().getValue(), 2);
        LOGGER.debug("EncryptedSniLength: {}", msg.getEncryptedSniLength().getValue());
    }

    private void writeEncryptedSni(EncryptedServerNameIndicationExtensionMessage msg) {
        this.appendBytes((byte[])msg.getEncryptedSni().getValue());
        LOGGER.debug("EncryptedSni: {}", msg.getEncryptedSni().getValue());
    }
}

