/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.tlsattacker.core.protocol.message.extension.ConnectionIdExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectionIdExtensionSerializer
extends ExtensionSerializer<ConnectionIdExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ConnectionIdExtensionMessage message;

    public ConnectionIdExtensionSerializer(ConnectionIdExtensionMessage message) {
        super(message);
        this.message = message;
    }

    @Override
    public byte[] serializeExtensionContent() {
        LOGGER.debug("Serializing ConnectionIdExtensionMessage");
        this.serializeConnectionIdLength(this.message);
        this.serializeConnectionId(this.message);
        return this.getAlreadySerialized();
    }

    private void serializeConnectionIdLength(ConnectionIdExtensionMessage msg) {
        this.appendInt((Integer)msg.getConnectionIdLength().getValue(), 1);
        LOGGER.debug("ConnectionId length: {}", msg.getConnectionIdLength().getValue());
    }

    private void serializeConnectionId(ConnectionIdExtensionMessage msg) {
        this.appendBytes((byte[])msg.getConnectionId().getValue());
        LOGGER.debug("ConnectionId: {}", msg.getConnectionId().getValue());
    }
}

