/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.RSAServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ServerKeyExchangeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RSAServerKeyExchangeSerializer<T extends RSAServerKeyExchangeMessage>
extends ServerKeyExchangeSerializer<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final T msg;

    public RSAServerKeyExchangeSerializer(T message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing RSAServerKeyExchangeMessage");
        this.writeModulusLength(this.msg);
        this.writeModulus(this.msg);
        this.writePublicExponentLength(this.msg);
        this.writePublicExponent(this.msg);
        if (this.isTLS12() || this.isDTLS12()) {
            this.writeSignatureAndHashAlgorithm(this.msg);
        }
        this.writeSignatureLength(this.msg);
        this.writeSignature(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeModulusLength(T msg) {
        this.appendInt((Integer)((RSAServerKeyExchangeMessage)msg).getModulusLength().getValue(), 2);
    }

    private void writeModulus(T msg) {
        this.appendBytes((byte[])((RSAServerKeyExchangeMessage)msg).getModulus().getValue());
    }

    private void writePublicExponentLength(T msg) {
        this.appendInt((Integer)((ServerKeyExchangeMessage)msg).getPublicKeyLength().getValue(), 2);
    }

    private void writePublicExponent(T msg) {
        this.appendBytes((byte[])((ServerKeyExchangeMessage)msg).getPublicKey().getValue());
    }

    private void writeSignatureAndHashAlgorithm(T msg) {
        this.appendBytes((byte[])((ServerKeyExchangeMessage)msg).getSignatureAndHashAlgorithm().getValue());
        LOGGER.debug("SignatureAndHaslAlgorithm: {}", ((ServerKeyExchangeMessage)msg).getSignatureAndHashAlgorithm().getValue());
    }

    private void writeSignatureLength(T msg) {
        this.appendInt((Integer)((ServerKeyExchangeMessage)msg).getSignatureLength().getValue(), 2);
        LOGGER.debug("SignatureLength: {}", ((ServerKeyExchangeMessage)msg).getSignatureLength().getValue());
    }

    private void writeSignature(T msg) {
        this.appendBytes((byte[])((ServerKeyExchangeMessage)msg).getSignature().getValue());
        LOGGER.debug("Signature: {}", ((ServerKeyExchangeMessage)msg).getSignature().getValue());
    }
}

