/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.PskDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.DHEServerKeyExchangeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskDheServerKeyExchangeSerializer
extends DHEServerKeyExchangeSerializer<PskDheServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PskDheServerKeyExchangeMessage msg;

    public PskDheServerKeyExchangeSerializer(PskDheServerKeyExchangeMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing PSKDHEServerKeyExchangeMessage");
        this.writePSKIdentityHintLength(this.msg);
        this.writePSKIdentityHint(this.msg);
        super.serializeDheParams();
        return this.getAlreadySerialized();
    }

    private void writePSKIdentityHintLength(PskDheServerKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getIdentityHintLength().getValue(), 2);
        LOGGER.debug("SerializedPSKIdentityHintLength: {}", (Object)msg.getIdentityHintLength());
    }

    private void writePSKIdentityHint(PskDheServerKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getIdentityHint().getValue());
        LOGGER.debug("SerializedPSKIdentityHint: {}", msg.getIdentityHint().getValue());
    }
}

