/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.protocol.ProtocolMessageSerializer;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HandshakeMessageSerializer<T extends HandshakeMessage>
extends ProtocolMessageSerializer<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public HandshakeMessageSerializer(T message) {
        super(message);
    }

    protected void writeType() {
        this.appendByte((Byte)((HandshakeMessage)this.message).getType().getValue());
        LOGGER.debug("Type: {}", ((HandshakeMessage)this.message).getType().getValue());
    }

    protected void writeLength() {
        this.appendInt((Integer)((HandshakeMessage)this.message).getLength().getValue(), 3);
        LOGGER.debug("Length: {}", ((HandshakeMessage)this.message).getLength().getValue());
    }

    private void writeContent() {
        this.appendBytes((byte[])((HandshakeMessage)this.message).getMessageContent().getValue());
        LOGGER.debug("HandshakeMessage content: {}", ((HandshakeMessage)this.message).getMessageContent().getValue());
    }

    @Override
    protected byte[] serializeBytes() {
        this.writeType();
        this.writeLength();
        this.writeContent();
        return this.getAlreadySerialized();
    }

    public abstract byte[] serializeHandshakeMessageContent();

    protected boolean hasExtensionLengthField() {
        return ((HandshakeMessage)this.message).getExtensionsLength() != null;
    }

    protected void writeExtensionLength() {
        this.appendInt((Integer)((HandshakeMessage)this.message).getExtensionsLength().getValue(), 2);
        LOGGER.debug("ExtensionLength: {}", ((HandshakeMessage)this.message).getExtensionsLength().getValue());
    }

    protected boolean hasExtensions() {
        return ((HandshakeMessage)this.message).getExtensionBytes() != null;
    }

    protected void writeExtensionBytes() {
        this.appendBytes((byte[])((HandshakeMessage)this.message).getExtensionBytes().getValue());
        LOGGER.debug("ExtensionBytes: {}", ((HandshakeMessage)this.message).getExtensionBytes().getValue());
    }
}

