/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ServerKeyExchangeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECDHEServerKeyExchangeSerializer<T extends ECDHEServerKeyExchangeMessage>
extends ServerKeyExchangeSerializer<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final T msg;

    public ECDHEServerKeyExchangeSerializer(T message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing ECDHEServerKeyExchangeMessage");
        this.writeCurveType(this.msg);
        this.writeNamedGroup(this.msg);
        this.writeSerializedPublicKeyLength(this.msg);
        this.writeSerializedPublicKey(this.msg);
        if (this.isTLS12() || this.isDTLS12()) {
            this.writeSignatureAndHashAlgorithm(this.msg);
            SignatureAndHashAlgorithm sigHashAlg = SignatureAndHashAlgorithm.getSignatureAndHashAlgorithm((byte[])((ServerKeyExchangeMessage)this.msg).getSignatureAndHashAlgorithm().getValue());
            if (sigHashAlg == null || sigHashAlg.getSignatureAlgorithm() != null) {
                this.writeSignatureLength(this.msg);
                this.writeSignature(this.msg);
            }
        } else {
            this.writeSignatureLength(this.msg);
            this.writeSignature(this.msg);
        }
        return this.getAlreadySerialized();
    }

    protected byte[] serializeEcDheParams() {
        this.writeCurveType(this.msg);
        this.writeNamedGroup(this.msg);
        this.writeSerializedPublicKeyLength(this.msg);
        this.writeSerializedPublicKey(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeCurveType(T msg) {
        this.appendByte((Byte)((ECDHEServerKeyExchangeMessage)msg).getGroupType().getValue());
        LOGGER.debug("CurveType: {}", ((ECDHEServerKeyExchangeMessage)msg).getGroupType().getValue());
    }

    private void writeNamedGroup(T msg) {
        this.appendBytes((byte[])((ECDHEServerKeyExchangeMessage)msg).getNamedGroup().getValue());
        LOGGER.debug("NamedGroup: {}", ((ECDHEServerKeyExchangeMessage)msg).getNamedGroup().getValue());
    }

    private void writeSerializedPublicKeyLength(T msg) {
        this.appendInt((Integer)((ServerKeyExchangeMessage)msg).getPublicKeyLength().getValue(), 1);
        LOGGER.debug("SerializedPublicKeyLength: {}", ((ServerKeyExchangeMessage)msg).getPublicKeyLength().getValue());
    }

    private void writeSerializedPublicKey(T msg) {
        this.appendBytes((byte[])((ServerKeyExchangeMessage)msg).getPublicKey().getValue());
        LOGGER.debug("SerializedPublicKey: {}", ((ServerKeyExchangeMessage)msg).getPublicKey().getValue());
    }

    private void writeSignatureAndHashAlgorithm(T msg) {
        this.appendBytes((byte[])((ServerKeyExchangeMessage)msg).getSignatureAndHashAlgorithm().getValue());
        LOGGER.debug("SignatureAndHashAlgorithm: {}", ((ServerKeyExchangeMessage)msg).getSignatureAndHashAlgorithm().getValue());
    }

    private void writeSignatureLength(T msg) {
        this.appendInt((Integer)((ServerKeyExchangeMessage)msg).getSignatureLength().getValue(), 2);
        LOGGER.debug("SignatureLength: {}", ((ServerKeyExchangeMessage)msg).getSignatureLength().getValue());
    }

    private void writeSignature(T msg) {
        this.appendBytes((byte[])((ServerKeyExchangeMessage)msg).getSignature().getValue());
        LOGGER.debug("Signature: {}", ((ServerKeyExchangeMessage)msg).getSignature().getValue());
    }
}

