/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.DHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ClientKeyExchangeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DHClientKeyExchangeSerializer<T extends DHClientKeyExchangeMessage>
extends ClientKeyExchangeSerializer<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final T msg;

    public DHClientKeyExchangeSerializer(T message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing DHClientKeyExchangeMessage");
        return this.serializeDhParams();
    }

    protected byte[] serializeDhParams() {
        this.writeSerializedPublicKeyLength(this.msg);
        this.writeSerializedPublicKey(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeSerializedPublicKeyLength(T msg) {
        this.appendInt((Integer)((ClientKeyExchangeMessage)msg).getPublicKeyLength().getValue(), 2);
        LOGGER.debug("SerializedPublicKexLength: {}", ((ClientKeyExchangeMessage)msg).getPublicKeyLength().getValue());
    }

    private void writeSerializedPublicKey(T msg) {
        this.appendBytes((byte[])((ClientKeyExchangeMessage)msg).getPublicKey().getValue());
        LOGGER.debug("SerializedPublicKey: {}", ((ClientKeyExchangeMessage)msg).getPublicKey().getValue());
    }
}

