/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateVerifyMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.HandshakeMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateVerifySerializer
extends HandshakeMessageSerializer<CertificateVerifyMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CertificateVerifyMessage msg;
    private ProtocolVersion version;

    public CertificateVerifySerializer(CertificateVerifyMessage message, ProtocolVersion version) {
        super(message);
        this.version = version;
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing CertificateVerifyMessage");
        if (this.version == ProtocolVersion.TLS12 || this.version == ProtocolVersion.DTLS12 || this.version.is13()) {
            this.writeSignatureHashAlgorithm(this.msg);
        }
        this.writeSignatureLength(this.msg);
        this.writeSignature(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeSignatureHashAlgorithm(CertificateVerifyMessage msg) {
        this.appendBytes((byte[])msg.getSignatureHashAlgorithm().getValue());
        LOGGER.debug("SignatureHashAlgorithms: {}", msg.getSignatureHashAlgorithm().getValue());
    }

    private void writeSignatureLength(CertificateVerifyMessage msg) {
        this.appendInt((Integer)msg.getSignatureLength().getValue(), 2);
        LOGGER.debug("SignatureLength: {}", msg.getSignatureLength().getValue());
    }

    private void writeSignature(CertificateVerifyMessage msg) {
        this.appendBytes((byte[])msg.getSignature().getValue());
        LOGGER.debug("Signature: {}", msg.getSignature().getValue());
    }
}

