/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.RenegotiationInfoExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenegotiationInfoExtensionPreparator
extends ExtensionPreparator<RenegotiationInfoExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final RenegotiationInfoExtensionMessage message;

    public RenegotiationInfoExtensionPreparator(Chooser chooser, RenegotiationInfoExtensionMessage message) {
        super(chooser, message);
        this.message = message;
    }

    @Override
    public void prepareExtensionContent() {
        if (this.chooser.getContext().getTlsContext().getLastClientVerifyData() != null && this.chooser.getContext().getTlsContext().getLastServerVerifyData() != null) {
            if (this.chooser.getContext().getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
                this.message.setRenegotiationInfo(this.chooser.getContext().getTlsContext().getLastClientVerifyData());
            } else {
                this.message.setRenegotiationInfo(DataConverter.concatenate((byte[][])new byte[][]{this.chooser.getContext().getTlsContext().getLastClientVerifyData(), this.chooser.getContext().getTlsContext().getLastServerVerifyData()}));
            }
        } else if (this.chooser.getContext().getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
            this.message.setRenegotiationInfo(this.chooser.getConfig().getDefaultClientRenegotiationInfo());
        } else {
            this.message.setRenegotiationInfo(this.chooser.getConfig().getDefaultServerRenegotiationInfo());
        }
        this.message.setRenegotiationInfoLength(((byte[])this.message.getRenegotiationInfo().getValue()).length);
        LOGGER.debug("Prepared the RenegotiationInfo extension with info {}", this.message.getRenegotiationInfo().getValue());
    }
}

