/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.tlsattacker.core.protocol.message.extension.PasswordSaltExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PasswordSaltExtensionPreparator
extends ExtensionPreparator<PasswordSaltExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PasswordSaltExtensionMessage msg;

    public PasswordSaltExtensionPreparator(Chooser chooser, PasswordSaltExtensionMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        LOGGER.debug("Preparing PasswordSaltExtension");
        this.prepareSalt(this.msg);
        this.prepareSaltLength(this.msg);
    }

    private void prepareSalt(PasswordSaltExtensionMessage msg) {
        msg.setSalt(this.chooser.getConfig().getDefaultServerPWDSalt());
        LOGGER.debug("Salt: {}", (Object)msg.getSalt());
    }

    private void prepareSaltLength(PasswordSaltExtensionMessage msg) {
        msg.setSaltLength(((byte[])msg.getSalt().getValue()).length);
        LOGGER.debug("SaltLength: {}", msg.getSaltLength().getValue());
    }
}

