/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.RSAClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RSAClientKeyExchangePreparator<T extends RSAClientKeyExchangeMessage>
extends ClientKeyExchangePreparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected byte[] padding;
    protected byte[] premasterSecret;
    protected byte[] clientServerRandom;
    protected byte[] masterSecret;
    protected byte[] encrypted;
    protected final T msg;

    public RSAClientKeyExchangePreparator(Chooser chooser, T message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing RSAClientKeyExchangeMessage");
        ((RSAClientKeyExchangeMessage)this.msg).prepareComputations();
        this.prepareClientServerRandom(this.msg);
        ((RSAClientKeyExchangeMessage)this.msg).getComputations().setModulus(this.chooser.getRsaKeyExchangeModulus());
        ((RSAClientKeyExchangeMessage)this.msg).getComputations().setPublicExponent(this.chooser.getRsaKeyExchangePublicExponent());
        BigInteger modulus = (BigInteger)((RSAClientKeyExchangeMessage)this.msg).getComputations().getModulus().getValue();
        int ceiledModulusByteLength = (int)Math.ceil((double)modulus.bitLength() / 8.0);
        int randomByteLength = ceiledModulusByteLength - 48 - 3;
        if (randomByteLength > 0) {
            this.padding = new byte[randomByteLength];
            this.chooser.getContext().getTlsContext().getRandom().nextBytes(this.padding);
            DataConverter.makeArrayNonZero((byte[])this.padding);
        } else {
            this.padding = new byte[0];
        }
        this.preparePadding(this.msg);
        this.premasterSecret = this.generatePremasterSecret();
        this.preparePremasterSecret(this.msg);
        this.preparePlainPaddedPremasterSecret(this.msg);
        byte[] paddedPremasterSecret = (byte[])((RSAClientKeyExchangeMessage)this.msg).getComputations().getPlainPaddedPremasterSecret().getValue();
        if (paddedPremasterSecret.length == 0) {
            LOGGER.warn("paddedPremasterSecret length is zero length!");
            paddedPremasterSecret = new byte[]{0};
        }
        BigInteger biPaddedPremasterSecret = new BigInteger(1, paddedPremasterSecret);
        LOGGER.debug("Modulus: {}", ((RSAClientKeyExchangeMessage)this.msg).getComputations().getModulus().getValue());
        LOGGER.debug("Public Exponent: {}", ((RSAClientKeyExchangeMessage)this.msg).getComputations().getPublicExponent().getValue());
        BigInteger biEncrypted = biPaddedPremasterSecret.modPow(((BigInteger)((RSAClientKeyExchangeMessage)this.msg).getComputations().getPublicExponent().getValue()).abs(), ((BigInteger)((RSAClientKeyExchangeMessage)this.msg).getComputations().getModulus().getValue()).abs());
        this.encrypted = DataConverter.bigIntegerToByteArray((BigInteger)biEncrypted, (int)ceiledModulusByteLength, (boolean)true);
        this.prepareSerializedPublicKey(this.msg);
        this.premasterSecret = this.manipulatePremasterSecret(this.premasterSecret);
        this.preparePremasterSecret(this.msg);
        this.prepareSerializedPublicKey(this.msg);
        this.prepareSerializedPublicKeyLength(this.msg);
    }

    protected byte[] generatePremasterSecret() {
        ((RSAClientKeyExchangeMessage)this.msg).getComputations().setPremasterSecretProtocolVersion(this.chooser.getHighestClientProtocolVersion().getValue());
        byte[] tempPremasterSecret = new byte[46];
        this.chooser.getContext().getTlsContext().getRandom().nextBytes(tempPremasterSecret);
        return DataConverter.concatenate((byte[][])new byte[][]{(byte[])((RSAClientKeyExchangeMessage)this.msg).getComputations().getPremasterSecretProtocolVersion().getValue(), tempPremasterSecret});
    }

    protected void preparePadding(T msg) {
        ((RSAClientKeyExchangeMessage)msg).getComputations().setPadding(this.padding);
        LOGGER.debug("Padding: {}", ((RSAClientKeyExchangeMessage)msg).getComputations().getPadding().getValue());
    }

    protected void preparePremasterSecret(T msg) {
        ((RSAClientKeyExchangeMessage)msg).getComputations().setPremasterSecret(this.premasterSecret);
        LOGGER.debug("PremasterSecret: {}", ((RSAClientKeyExchangeMessage)msg).getComputations().getPremasterSecret().getValue());
    }

    protected void preparePlainPaddedPremasterSecret(T msg) {
        ((RSAClientKeyExchangeMessage)msg).getComputations().setPlainPaddedPremasterSecret(DataConverter.concatenate((byte[][])new byte[][]{{0, 2}, this.padding, {0}, (byte[])((RSAClientKeyExchangeMessage)msg).getComputations().getPremasterSecret().getValue()}));
        LOGGER.debug("PlainPaddedPremasterSecret: {}", ((RSAClientKeyExchangeMessage)msg).getComputations().getPlainPaddedPremasterSecret().getValue());
    }

    protected void prepareClientServerRandom(T msg) {
        this.clientServerRandom = DataConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()});
        ((RSAClientKeyExchangeMessage)msg).getComputations().setClientServerRandom(this.clientServerRandom);
        LOGGER.debug("ClientServerRandom: {}", ((RSAClientKeyExchangeMessage)msg).getComputations().getClientServerRandom().getValue());
    }

    protected void prepareSerializedPublicKey(T msg) {
        ((ClientKeyExchangeMessage)msg).setPublicKey(this.encrypted);
        LOGGER.debug("SerializedPublicKey (encrypted premaster secret): {}", ((ClientKeyExchangeMessage)msg).getPublicKey().getValue());
    }

    protected void prepareSerializedPublicKeyLength(T msg) {
        ((ClientKeyExchangeMessage)msg).setPublicKeyLength(((byte[])((ClientKeyExchangeMessage)msg).getPublicKey().getValue()).length);
        LOGGER.debug("SerializedPublicKeyLength (encrypted premaster secret length): {}", ((ClientKeyExchangeMessage)msg).getPublicKeyLength().getValue());
    }

    public byte[] decryptPremasterSecret() {
        BigInteger bigIntegerEncryptedPremasterSecret = new BigInteger(1, (byte[])((ClientKeyExchangeMessage)this.msg).getPublicKey().getValue());
        BigInteger serverPrivateKey = this.chooser.getServerX509Chooser().getSubjectRsaPrivateKey();
        if (this.chooser.getServerX509Chooser().getSubjectRsaModulus().equals(BigInteger.ZERO)) {
            LOGGER.warn("RSA modulus is zero, returning new byte[0] as decryptedPremasterSecret");
            return new byte[0];
        }
        BigInteger decrypted = bigIntegerEncryptedPremasterSecret.modPow(serverPrivateKey.abs(), this.chooser.getServerX509Chooser().getSubjectRsaModulus().abs());
        return decrypted.toByteArray();
    }

    @Override
    public void prepareAfterParse() {
        LOGGER.debug("Preparing RSAClientKeyExchangeMessage");
        ((RSAClientKeyExchangeMessage)this.msg).prepareComputations();
        this.prepareClientServerRandom(this.msg);
        ((RSAClientKeyExchangeMessage)this.msg).getComputations().setModulus(this.chooser.getRsaKeyExchangeModulus());
        ((RSAClientKeyExchangeMessage)this.msg).getComputations().setPrivateKey(this.chooser.getRsaKeyExchangePrivateKey());
        int keyByteLength = ((BigInteger)((RSAClientKeyExchangeMessage)this.msg).getComputations().getModulus().getValue()).bitLength() / 8;
        LOGGER.debug("Decrypting premasterSecret");
        int randomByteLength = keyByteLength - 48 - 1;
        byte[] paddedPremasterSecret = this.decryptPremasterSecret();
        LOGGER.debug("PaddedPremaster: {}", (Object)paddedPremasterSecret);
        if (randomByteLength < paddedPremasterSecret.length && randomByteLength > 0) {
            this.premasterSecret = Arrays.copyOfRange(paddedPremasterSecret, randomByteLength, paddedPremasterSecret.length);
            this.premasterSecret = this.manipulatePremasterSecret(this.premasterSecret);
            this.preparePremasterSecret(this.msg);
            if (this.premasterSecret.length > 2) {
                ((RSAClientKeyExchangeMessage)this.msg).getComputations().setPremasterSecretProtocolVersion(Arrays.copyOfRange(this.premasterSecret, 0, 2));
                LOGGER.debug("PMS Protocol Version {}", ((RSAClientKeyExchangeMessage)this.msg).getComputations().getPremasterSecretProtocolVersion().getValue());
            } else {
                LOGGER.warn("Decrypted PMS is not long enough to contain protocol version bytes");
            }
        } else {
            LOGGER.warn("RandomByteLength too short! Using empty premasterSecret!");
            this.premasterSecret = new byte[0];
        }
    }

    protected byte[] manipulatePremasterSecret(byte[] premasterSecret) {
        return premasterSecret;
    }
}

