/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.supplementaldata;

import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.protocol.message.supplementaldata.SupplementalDataEntry;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SupplementalDataEntryParser
extends Parser<SupplementalDataEntry> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SupplementalDataEntryParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(SupplementalDataEntry entry) {
        LOGGER.debug("Parsing SupplementalDataEntry");
        this.parseSupplementalDataEntryType(entry);
        this.parseSupplementalDataEntryLength(entry);
        this.parseSupplementalDataEntry(entry);
    }

    private void parseSupplementalDataEntryType(SupplementalDataEntry entry) {
        entry.setSupplementalDataEntryType(this.parseIntField(2));
        LOGGER.debug("SupplementalDataEntryType: {}", entry.getSupplementalDataEntryType().getValue());
    }

    private void parseSupplementalDataEntryLength(SupplementalDataEntry entry) {
        entry.setSupplementalDataEntryLength(this.parseIntField(2));
        LOGGER.debug("SupplementalDataEntryLength: {}", entry.getSupplementalDataEntryLength().getValue());
    }

    private void parseSupplementalDataEntry(SupplementalDataEntry entry) {
        entry.setSupplementalDataEntry(this.parseByteArrayField((Integer)entry.getSupplementalDataEntryLength().getValue()));
        LOGGER.debug("SupplementalDataEntry: {}", entry.getSupplementalDataEntry().getValue());
    }
}

