/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PWDProtectExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PWDProtectExtensionParser
extends ExtensionParser<PWDProtectExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PWDProtectExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(PWDProtectExtensionMessage msg) {
        LOGGER.debug("Parsing PWDProtectExtensionMessage");
        this.parseUsernameLength(msg);
        this.parseUsername(msg);
    }

    private void parseUsernameLength(PWDProtectExtensionMessage msg) {
        msg.setUsernameLength(this.parseIntField(1));
        LOGGER.debug("UsernameLength: {}", msg.getUsernameLength().getValue());
    }

    private void parseUsername(PWDProtectExtensionMessage msg) {
        msg.setUsername(this.parseByteArrayField((Integer)msg.getUsernameLength().getValue()));
        LOGGER.debug("Username: {}", (Object)msg.getUsername());
    }
}

