/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.KeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.KeyShareEntryParser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyShareExtensionParser
extends ExtensionParser<KeyShareExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private List<KeyShareEntry> entryList;
    private boolean helloRetryRequestHint = false;
    private final ConnectionEndType talkingConnectionEndType;

    public KeyShareExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
        this.talkingConnectionEndType = tlsContext.getTalkingConnectionEndType();
    }

    @Override
    public void parse(KeyShareExtensionMessage msg) {
        if (this.helloRetryRequestHint) {
            this.parseHRRKeyShare(msg);
        } else {
            this.parseRegularKeyShare(msg);
        }
        msg.setRetryRequestMode(this.helloRetryRequestHint);
    }

    private void parseRegularKeyShare(KeyShareExtensionMessage msg) {
        LOGGER.debug("Parsing KeyShareExtensionMessage as regular KeyShareExtension");
        this.entryList = new LinkedList<KeyShareEntry>();
        if (this.talkingConnectionEndType == ConnectionEndType.CLIENT) {
            this.parseKeyShareListLength(msg);
            this.parseKeyShareListBytes(msg);
            ByteArrayInputStream innerStream = new ByteArrayInputStream((byte[])msg.getKeyShareListBytes().getValue());
            while (innerStream.available() > 0) {
                KeyShareEntry entry = this.parseKeyShareEntry(innerStream);
                this.entryList.add(entry);
            }
        } else {
            byte[] keyShareBytes = this.parseByteArrayField(this.getBytesLeft());
            msg.setKeyShareListBytes(keyShareBytes);
            this.entryList.add(this.parseKeyShareEntry(new ByteArrayInputStream(keyShareBytes)));
        }
        this.setKeyShareList(msg);
    }

    private KeyShareEntry parseKeyShareEntry(ByteArrayInputStream innerStream) {
        KeyShareEntryParser parser = new KeyShareEntryParser(innerStream, this.helloRetryRequestHint);
        KeyShareEntry entry = new KeyShareEntry();
        parser.parse(entry);
        return entry;
    }

    private void parseHRRKeyShare(KeyShareExtensionMessage msg) {
        LOGGER.debug("Parsing KeyShareExtensionMessage as HelloRetryRequest KeyShareExtension");
        msg.setKeyShareListBytes(this.parseByteArrayField(2));
        this.entryList = new LinkedList<KeyShareEntry>();
        KeyShareEntry entry = this.parseKeyShareEntry(new ByteArrayInputStream((byte[])msg.getKeyShareListBytes().getValue()));
        this.entryList.add(entry);
        this.setKeyShareList(msg);
    }

    private void parseKeyShareListLength(KeyShareExtensionMessage msg) {
        msg.setKeyShareListLength(this.parseIntField(2));
        LOGGER.debug("KeyShareListLength: {}", msg.getKeyShareListLength().getValue());
    }

    private void parseKeyShareListBytes(KeyShareExtensionMessage msg) {
        msg.setKeyShareListBytes(this.parseByteArrayField((Integer)msg.getKeyShareListLength().getValue()));
        LOGGER.debug("KeyShareListBytes: {}", msg.getKeyShareListBytes().getValue());
    }

    private void setKeyShareList(KeyShareExtensionMessage msg) {
        msg.setKeyShareList(this.entryList);
    }

    public boolean isHelloRetryRequestHint() {
        return this.helloRetryRequestHint;
    }

    public void setHelloRetryRequestHint(boolean helloRetryRequestHint) {
        this.helloRetryRequestHint = helloRetryRequestHint;
    }
}

