/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyShareEntryParser
extends Parser<KeyShareEntry> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final boolean helloRetryRequestForm;

    public KeyShareEntryParser(InputStream stream, boolean helloRetryRequestForm) {
        super(stream);
        this.helloRetryRequestForm = helloRetryRequestForm;
    }

    @Override
    public void parse(KeyShareEntry entry) {
        LOGGER.debug("Parsing KeyShareEntry");
        this.parseKeyShareGroup(entry);
        if (!this.helloRetryRequestForm) {
            this.parseKeyShareLength(entry);
            this.parseKeyShare(entry);
        }
        entry.setGroupConfig(NamedGroup.getNamedGroup((byte[])entry.getGroup().getValue()));
    }

    private void parseKeyShareGroup(KeyShareEntry pair) {
        pair.setGroup(this.parseByteArrayField(2));
        LOGGER.debug("KeyShareGroup: {}", pair.getGroup().getValue());
    }

    private void parseKeyShareLength(KeyShareEntry pair) {
        pair.setPublicKeyLength(this.parseIntField(2));
        LOGGER.debug("KeyShareLength: {}", pair.getPublicKeyLength().getValue());
    }

    private void parseKeyShare(KeyShareEntry pair) {
        pair.setPublicKey(this.parseByteArrayField((Integer)pair.getPublicKeyLength().getValue()));
        LOGGER.debug("KeyShare: {}", pair.getPublicKey().getValue());
    }
}

