/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.constants.EchClientHelloType;
import de.rub.nds.tlsattacker.core.constants.hpke.HpkeAeadFunction;
import de.rub.nds.tlsattacker.core.constants.hpke.HpkeKeyDerivationFunction;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedClientHelloExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ech.HpkeCipherSuite;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptedClientHelloExtensionParser
extends ExtensionParser<EncryptedClientHelloExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public EncryptedClientHelloExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(EncryptedClientHelloExtensionMessage msg) {
        if ((Integer)msg.getExtensionLength().getValue() == 0) {
            LOGGER.debug("Received empty ECH Extension");
            return;
        }
        if (this.getBytesLeft() == 8) {
            this.parseAcceptConfirmation(msg);
        } else {
            this.parseEchClientHelloType(msg);
            switch (msg.getEchClientHelloType()) {
                case OUTER: {
                    this.parseHpkeCipherSuite(msg);
                    this.parseConfigId(msg);
                    this.parseEnc(msg);
                    this.parsePayload(msg);
                    break;
                }
                case INNER: {
                    break;
                }
                default: {
                    LOGGER.warn("Received unknown clientHelloType in ECH extension");
                }
            }
        }
    }

    private void parseEchClientHelloType(EncryptedClientHelloExtensionMessage msg) {
        byte[] echClientHelloTypeBytes = this.parseByteArrayField(1);
        EchClientHelloType echClientHelloType = EchClientHelloType.getEnumByByte(echClientHelloTypeBytes);
        msg.setEchClientHelloType(echClientHelloType);
        LOGGER.info("EchClientHelloType: {}", (Object)echClientHelloType);
    }

    private void parseHpkeCipherSuite(EncryptedClientHelloExtensionMessage msg) {
        HpkeKeyDerivationFunction hkdfAlgorithm = this.parseKdfId();
        HpkeAeadFunction aeadAlgorithm = this.parseAEADId();
        HpkeCipherSuite hpkeCipherSuite = new HpkeCipherSuite(hkdfAlgorithm, aeadAlgorithm);
        msg.setHpkeCipherSuite(hpkeCipherSuite);
    }

    private HpkeKeyDerivationFunction parseKdfId() {
        byte[] kdfId = this.parseByteArrayField(2);
        return HpkeKeyDerivationFunction.getEnumByByte(kdfId);
    }

    private HpkeAeadFunction parseAEADId() {
        byte[] aeadId = this.parseByteArrayField(2);
        return HpkeAeadFunction.getEnumByByte(aeadId);
    }

    private void parseConfigId(EncryptedClientHelloExtensionMessage msg) {
        int configId = this.parseIntField(1);
        msg.setConfigId(configId);
        LOGGER.debug("Config ID: {}", (Object)msg.getConfigId());
    }

    private void parseEnc(EncryptedClientHelloExtensionMessage msg) {
        int encLen = this.parseIntField(2);
        msg.setEncLength(encLen);
        byte[] enc = this.parseByteArrayField(encLen);
        msg.setEnc(enc);
        LOGGER.debug("Enc: {}", (Object)msg.getEnc());
    }

    private void parsePayload(EncryptedClientHelloExtensionMessage msg) {
        int payloadLen = this.parseIntField(2);
        msg.setPayloadLength(payloadLen);
        byte[] payload = this.parseByteArrayField(payloadLen);
        msg.setPayload(payload);
        LOGGER.debug("Payload: {}", (Object)msg.getPayload());
    }

    private void parseAcceptConfirmation(EncryptedClientHelloExtensionMessage msg) {
        byte[] acceptConfirmation = this.parseByteArrayField(8);
        msg.setAcceptConfirmation(acceptConfirmation);
    }
}

