/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.certificatestatus.CertificateStatusObject;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CertificateStatusRequestExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.CertificateStatusGenericParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateStatusRequestExtensionParser
extends ExtensionParser<CertificateStatusRequestExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ProtocolVersion selectedVersion;

    public CertificateStatusRequestExtensionParser(InputStream stream, ProtocolVersion selectedVersion, TlsContext tlsContext) {
        super(stream, tlsContext);
        this.selectedVersion = selectedVersion;
    }

    @Override
    public void parse(CertificateStatusRequestExtensionMessage msg) {
        if (!this.selectedVersion.is13() && this.getTlsContext().getTalkingConnectionEndType() == ConnectionEndType.SERVER) {
            return;
        }
        if (!this.selectedVersion.is13() || this.getTlsContext().getTalkingConnectionEndType().equals((Object)ConnectionEndType.CLIENT)) {
            msg.setCertificateStatusRequestType(this.parseIntField(1));
            LOGGER.debug("Parsed the status type " + String.valueOf(msg.getCertificateStatusRequestType().getValue()));
            msg.setResponderIDListLength(this.parseIntField(2));
            msg.setResponderIDList(this.parseByteArrayField((Integer)msg.getResponderIDListLength().getValue()));
            LOGGER.debug("Parsed the responder ID list with length {} and value {}", msg.getResponderIDListLength().getValue(), (Object)msg.getResponderIDList());
            msg.setRequestExtensionLength(this.parseIntField(2));
            msg.setRequestExtension(this.parseByteArrayField((Integer)msg.getRequestExtensionLength().getValue()));
            LOGGER.debug("Parsed the request extension with length {} and value {}", msg.getRequestExtensionLength().getValue(), (Object)msg.getRequestExtension());
        } else {
            this.parseAsCertificateStatus(msg);
        }
    }

    private void parseAsCertificateStatus(CertificateStatusRequestExtensionMessage msg) {
        CertificateStatusGenericParser certificateStatusGenericParser = new CertificateStatusGenericParser(new ByteArrayInputStream(this.parseByteArrayField((Integer)msg.getExtensionLength().getValue())));
        if (certificateStatusGenericParser.getBytesLeft() > 0) {
            CertificateStatusObject certificateStatus = new CertificateStatusObject();
            certificateStatusGenericParser.parse(certificateStatus);
            msg.setCertificateStatusType(certificateStatus.getType());
            msg.setOcspResponseLength(certificateStatus.getLength());
            msg.setOcspResponseBytes(certificateStatus.getOcspResponse());
        }
    }
}

